<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Mailer\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * @ORM\Entity
 * @ORM\Table (name="store_mail_template",options={"engine":"InnoDB"})
 */
class Template
{
    const TEMPLATE_TYPE_SYSTEM    = 0;
    const TEMPLATE_TYPE_USER      = 1;

    const TEMPLATE_TARGET_REGISTRATION = 1;
    const TEMPLATE_TARGET_FORGOT_PASSWORD = 2;
    const TEMPLATE_TARGET_ORDER_CONFIRMATION = 3;
    const TEMPLATE_TARGET_ORDER_STATUS_UPDATED = 4;
    const TEMPLATE_TARGET_ORDER_PAID = 4;
    const TEMPLATE_TARGET_ORDER_STATUS_PENDING = 5;
    const TEMPLATE_TARGET_ORDER_WAITING_PAYMENT = 6;
    const TEMPLATE_TARGET_ORDER_STATUS_PROCESSING = 7;
    const TEMPLATE_TARGET_ORDER_SHIPPED = 8;
    const TEMPLATE_TARGET_ORDER_ON_HOLD = 9;
    const TEMPLATE_TARGET_ORDER_CANCELED = 10;
    const TEMPLATE_TARGET_ORDER_COMPLETE = 11;
    const TEMPLATE_TARGET_ORDER_AWAITING_FULFILLMENT = 12;
    const TEMPLATE_TARGET_ORDER_CREATED_WEBMASTER = 13;

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(name="`type`", type="integer") */
    protected $type;

    /** @ORM\Column(type="integer") */
    protected $target;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $show_priority;

    /** @ORM\Column(type="string", length=255) */
    protected $name;

    /** @ORM\Column(type="text")  */
    protected $template;

    /** @ORM\Column(type="boolean", options={"default"=1}) */
    protected $active;

    /** @ORM\Column(type="boolean", options={"default"=0}) */
    protected $forceutf8;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return mixed
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param mixed $target
     */
    public function setTarget($target)
    {
        $this->target = $target;
    }

    /**
     * @param mixed $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * @param mixed $template
     */
    public function setTemplate($template)
    {
        $this->template = $template;
    }

    /**
     * @return mixed
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param mixed $active
     * @return $this
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }
    /**
     * @return mixed
     */
    public function getForceutf8()
    {
        return $this->forceutf8;
    }

    /**
     * @param mixed $forceutf8
     * @return $this
     */
    public function setForceutf8($forceutf8)
    {
        $this->forceutf8 = $forceutf8;
        return $this;
    }
}