<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Mailer\Form;


use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;

class TemplateType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $default = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'type',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'target',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'template',
                'required'  => true,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\EmailTemplate'
                    )
                ),
            ))
            ->add (array (
                'name'      => 'active',
                'required'  => false,
                'filters'=> array (
                ),
            ))
            ->add (array (
                'name'      => 'forceutf8',
                'required'  => false,
                'filters'=> array (
                ),
            ));
    }
}