<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Mailer\Service;

use Doctrine\ORM\Query;
use MotoStore\Mailer\Entity\Template;
use MotoStore\Mailer\Form\TemplateType;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;

class MailServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'mail_template';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.mail.template';
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new TemplateType (), new Template ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        return $this
            ->handleCollectionRequest ();
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id);
    }

    public function setActive ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']))
        {

            $mail_id     = $params ['id'];
            $active = false;
            if ($params ['active'] == 'true'){
                $active = true;
            }

            $em = $this
                ->collection
                ->getEntityManager ();
            /** @var Template $entity */
            $entity = $em->getRepository ('MotoStore\Mailer\Entity\Template')
                ->find ($mail_id);
            $entity
                ->setActive($active);

            $em->flush();

        }

    }

}