<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Order\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Order implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('o', 'ca', 'p', 'c', 'co', 's', 't','cur'))
            ->from ('MotoStore\Order\Entity\Order', 'o')
            ->leftJoin ('o.products', 'p')
            ->leftJoin ('o.customer', 'ca')
            ->leftJoin ('o.comments', 'c')
            ->leftJoin ('o.country', 'co')
            ->leftJoin ('o.state', 's')
            ->leftJoin ('o.transactions', 't')
            ->leftJoin ('o.currency', 'cur')
            ->orderBy ('o.id', 'DESC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'id'            => 'o.id',
            'order_id'      => 'o.order_id',
            'customer_id'   => 'o.customer_id',
            'status'        => 'o.status',
            'created_at'    => 'o.created_at',
            'updated_at'    => 'o.updated_at',
            'first_name'    => 'o.first_name',
            'last_name'     => 'o.last_name',
            'email'         => 'o.email',
            'company'       => 'o.company',
            'address1'      => 'o.address1',
            'address2'      => 'o.address2',
            'post_code'     => 'o.post_code',
            'city'          => 'o.city',
            'contact_phone' => 'o.contact_phone',
            'total_price'   => 'o.total_price'
        ));

        return $collection;
    }
}