<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Order\Form;


use MotoStore\Order\Entity\Comment;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Product;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use Zend\InputFilter\CollectionInputFilter;

class OrderType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies()
    {
        return array ();
    }

    public function init()
    {
        $products = new CollectionInputFilter ();

        $productType = new ProductType ();
        $productType
            ->setEntityManager ($this->getEntityManager ())
            ->init ();

        $products
            ->setInputFilter ($productType);

        $default = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'email',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'EmailAddress',
                        'options' => array (
                            'domain' => false
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'first_name',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'last_name',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'company',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'city',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'address1',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'address2',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'comment',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'delivery_date',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'post_code',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'contact_phone',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Regex',
                        'options' => array(
                            'pattern' => '/\+?\d{5,20}/',
                        ),
                    )
                ),
            ))
            ->add (array (
                'name'      => 'total_weight',
                'filters'   => array ($default),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'total_length',
                'filters'   => array ($default),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'total_depth',
                'filters'   => array ($default),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'total_width',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'subtotal_price',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'total_price',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'shipping_price',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'tax_price',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'discount',
                'required'  => true,
                'filters'   => array ($default),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add ($products, 'products');
    }

    /**
     * @param $data
     * @param $entity
     */
    protected function onPresetData (&$data, Order $entity)
    {
        $entity->createUniqueId ();
        $entity->setStatus (Order::ORDER_STATUS_PENDING);
        $this->applyComment ($data, $entity);
        $this->applyProducts ($data, $entity);
        $this->applyCountry ($data, $entity);
        $this->applyState ($data, $entity);
        $this->applyCustomer ($data, $entity);
    }

    protected function applyComment ($data, Order $entity)
    {
        if (!empty ($data ['comments']) && is_array ($data ['comments']))
        {
            $commentData = current($data ['comments']);

            $comment = new Comment ();
            $comment->setComment ($commentData ['comment']);
            $comment->setStatus (Order::ORDER_STATUS_PENDING);
            $comment->setOrder ($entity);

            $entity
                ->addComments (array ($comment));
        }
    }

    /**
     * @param $data
     * @param Order $entity
     */
    protected function applyCustomer ($data, Order $entity)
    {
        if (!empty ($data ['customer']))
        {
            $customer = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($data ['customer'] ['id']);

            if ($customer)
            {
                $entity->addCustomer ($customer);
            }
        }
    }

    /**
     * Set products
     *
     * @param $data
     * @param Order $entity
     */
    protected function applyProducts ($data, Order $entity)
    {
        $hydrator = $this->hydrator;

        $products = array_map (
            function ($data) use ($hydrator, $entity)
            {
                /**
                 * @var Product $product
                 */
                $product = $hydrator
                    ->hydrate ($data, new Product ());
                $product
                    ->setOrder ($entity);

                return $product;
            },
            $data ['products']
        );

        $entity->addProducts ($products);
    }

    /**
     * @param $data
     * @param Order $entity
     */
    public function applyCountry ($data, Order $entity)
    {
        $country = null;

        if (!empty ($data ['country'] ['id']))
        {
            $country = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\Country')
                ->find ($data ['country'] ['id']);
        }
        $entity->addCountry ($country);
    }

    /**
     * @param $data
     * @param Order $entity
     */
    public function applyState ($data, Order $entity)
    {
        $state = null;

        if (!empty ($data ['state'] ['id']))
        {
            $state = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\State')
                ->find ($data ['state'] ['id']);
        }
        $entity->addState ($state);
    }


}