<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Order\Form;


use MotoStore\Platform\Form\FormTypeAbstract;


class ProductType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies()
    {
        return array ();
    }

    public function init()
    {
        $this
            ->add (array (
                'name'      => 'sku',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'name',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'price',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'total_price',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'quantity',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ));
    }


}