<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Payment\DefaultMethod;


use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\PhpEnvironment\Request;

class DefaultMethod extends PaymentModule
{
    /**
     * Get payment processor
     *
     * @return string
     */
    public function getName ()
    {
        return 'DefaultMethod';
    }

    /**
     * Get Payment Icon
     * @return string
     */
    public function getImage()
    {
        return '';
    }

    /**
     * description
     * @return string
     */
    public function getDescription()
    {
        return 'Default Payment Method';
    }

    /**
     * Help text
     * @return string
     */
    public function getHelpText ()
    {
        return "Proceed Order with custom Payment";
    }

    /**
     * Set Payment Variables Array
     * @return array
     */
    public function setVariables()
    {
        $this->addVariable (
            self::OPTION_DISPLAY_NAME,
            array (
                'name' => 'Display Name',
                'type' => self::VARIABLE_TYPE_TEXT,
                'help' => '',
                'default' => 'Default Payment Method',
                'required' => true,
            )
        )
        ->addVariable (
            self::OPTION_ENABLED,
            array (
                'name' => 'Enabled',
                'type' => self::VARIABLE_TYPE_SELECT,
                'help' => '',
                'default' => 0,
                'required' => true,
                'options' => array (
                    0 => 'No',
                    1 => 'Yes'
                ),
            )
        );

    }

    /**
     * Proceed payment
     *
     * @param Order $order
     * @return mixed
     */
    public function checkout(Order $order)
    {

        $order->setStatus(Order::ORDER_WAITING_PAYMENT);
        $this
            ->serviceLocator
            ->get ('MotoStore\EntityManager')->merge ($order);

        $this
            ->serviceLocator
            ->get ('MotoStore\EntityManager')->flush ();

        Link::redirect ('checkout', 'success', array ('provider' => $this->getName ()));
    }

    /**
     * Handle Success
     *
     * @return mixed
     */
    public function handle(Request $request)
    {
        $this->getCart ()->setIsSuccess (true);
        // TODO: Implement handle() method.
    }


}