<?php

/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/
namespace MotoStore\Payment\Ideal;

use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\PhpEnvironment\Request;

class Ideal extends PaymentModule
{
    /** @var  \Mollie_API_Client */
    private $mollieApi;

    public function getName()
    {
        return 'Ideal';
    }

    public function getImage()
    {
        return 'Ideal.png';
    }

    public function getDescription()
    {
        return '';
    }

    public function getHelpText()
    {
        return '';
    }

    public function setVariables()
    {
        $this
            ->addVariable (
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'iDeal',
                    'required' => true,
                )
            )
            ->addVariable (
                'token',
                array(
                    'name' => 'Token',
                    'type' => self::VARIABLE_TYPE_PASSWORD,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )->addVariable (
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            );
            
    }

    /**
     * @param Order $order
     * @return mixed|void
     */
    public function checkout(Order $order)
    {
        $data = array (
            "amount"      => $order->getTotalPrice (),
            "description" => '#' . $order->getOrderId (),
            "redirectUrl" => Link::storeLink ('checkout', 'success', array ('provider' => $this->getName ()), false),
            "method"      => \Mollie_API_Object_Method::IDEAL,
            'metadata'    => array (
                'order_id' => $order->getOrderId (),
            )
        );

        try 
        {
            $payment = $this
                ->getMollieApi ()
                ->payments
                ->create ($data);
            
            if (!empty($payment))

            $this->getCart()->getStorage ()
                ->offsetSet ('molliePaymentId', $payment->id);

            $paymentUrl = $payment->getPaymentUrl ();

            header ('Location: ' . $paymentUrl);
            exit;
            
        }
        catch (\Exception $e)
        {
            error_log ('Mollie Payment Error:' . $e->getMessage());
            error_log (var_export($data, true));
        }
        Link::redirect ('checkout', 'success');
    }

    /**
     * @param Request $request
     * @return mixed|void
     * @throws \Mollie_API_Exception
     */
    public function handle(Request $request)
    {
        $payment_id = $this->getCart()
            ->getStorage ()
            ->offsetGet ('molliePaymentId');

        if (!empty($payment_id))
        {
            $payment = $this->getMollieApi ()->payments->get ($payment_id);


            if (!empty($payment->metadata->order_id))
            {
                $em = $this->serviceLocator->get ('MotoStore\EntityManager');
                $order = $this->getCurrentOrder ($payment->metadata->order_id);

                $transaction = new Transaction();
                $transaction->setOrder ($order);
                $transaction->setTransactionId ($payment_id);

                $date = new \DateTime ();

                $transaction->setDate ($date);
                $transaction->setPaymentMethod($this->getName ());


                $transaction->setStatus (Transaction::PAYMENT_STATUS_DECLINED);

                if ($payment->isPaid ())
                {
                    $transaction->setStatus (Transaction::PAYMENT_STATUS_PAID);
                    $order->setStatus (Order::ORDER_PAYMENT_ACCEPTED);
                    $this->getCart ()
                        ->setIsSuccess (true);
                    \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                }

                $transaction->setAdditional(json_encode ($payment));

                $em->persist ($transaction);

                $order->addTransaction ($transaction);

                $em->merge ($order);
                $em->flush ();
            }
        }
    }


    /**
     * @return \Mollie_API_Client
     * @throws \Mollie_API_Exception
     */
    private function getMollieApi ()
    {
        if (!$this->mollieApi)
        {
            $this->mollieApi = new \Mollie_API_Client ();
            $this->mollieApi->setApiKey($this->getOption('token'));
        }
        return $this->mollieApi;
    }




}