<?php

/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/
namespace MotoStore\Payment\MollieCom;

use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\PhpEnvironment\Request;


class MollieCom extends PaymentModule
{

    private $_paymentUrl = 'https://api.mollie.com/v1/payments';
    private $_paymentUrlSandbox = 'https://api.mollie.com/v1/payments';
    /** @var  \Mollie_API_Client */
    private $mollieApi;

    public function getName()
    {
        return 'MollieCom';
    }

    public function getImage()
    {
        return 'mollie.png';
    }

    public function getDescription()
    {
        return '';
    }

    public function getHelpText()
    {
        return 'Test API Key and Live API Key for your website you can get in your <a target="_blank" href="https://www.mollie.com/dashboard/settings/profiles">Mollie Account</a>';
    }

    public function setVariables()
    {
        $this
            ->addVariable (
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'Mollie',
                    'required' => true,
                )
            )->addVariable (
                'test_api_key',
                array(
                    'name' => 'Test API Key',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )->addVariable (
                'live_api_key',
                array(
                    'name' => 'Live API Key',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )->addVariable (
                'test_mode',
                array(
                    'name' => 'Test mode',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => 'The context mode of this module',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            )->addVariable (
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            );
            
    }

    /**
     * @param Order $order
     * @return mixed|void
     */
    public function checkout(Order $order)
    {
        $currency = $this->getCurrency ();
        $data = array (
            "amount"      => number_format ($order->getTotalPrice () * $currency->getExchangeRate (), 2, '.', ''),
            "description" => '#' . $order->getOrderId (),
            "redirectUrl" => Link::storeLink ('checkout', 'success', array ('provider' => $this->getName ()), false),
            'metadata'    => array (
                'order_id' => $order->getOrderId (),
            )
        );

        try
        {
            $payment = $this
                ->getMollieApi ()
                ->payments
                ->create ($data);

            if (!empty($payment))

                $this->getCart()->getStorage ()
                    ->offsetSet ('molliePaymentId', $payment->id);

            $paymentUrl = $payment->getPaymentUrl ();

            header ('Location: ' . $paymentUrl);
            exit;

        }
        catch (\Exception $e)
        {
            error_log ('Mollie Payment Error:' . $e->getMessage());
            error_log (var_export($data, true));
        }
        Link::redirect ('checkout', 'success');

    }
    /**
     * @param Request $request
     * @return mixed|void
     * @throws \Mollie_API_Exception
     */
    public function handle(Request $request)
    {
        $payment_id = $this->getCart()
            ->getStorage ()
            ->offsetGet ('molliePaymentId');

        if (!empty($payment_id))
        {
            $payment = $this->getMollieApi ()->payments->get ($payment_id);


            if (!empty($payment->metadata->order_id))
            {
                $em = $this->serviceLocator->get ('MotoStore\EntityManager');
                $order = $this->getCurrentOrder ($payment->metadata->order_id);

                $transaction = new Transaction();
                $transaction->setOrder ($order);
                $transaction->setTransactionId ($payment_id);

                $date = new \DateTime ();

                $transaction->setDate ($date);
                $transaction->setPaymentMethod($this->getName ());


                $transaction->setStatus (Transaction::PAYMENT_STATUS_DECLINED);

                if ($payment->isPaid ())
                {
                    $transaction->setStatus (Transaction::PAYMENT_STATUS_PAID);
                    $order->setStatus (Order::ORDER_PAYMENT_ACCEPTED);
                    $this->getCart ()
                        ->setIsSuccess (true);
                    \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                }

                $transaction->setAdditional(json_encode ($payment));

                $em->persist ($transaction);

                $order->addTransaction ($transaction);

                $em->merge ($order);
                $em->flush ();
            }
        }
    }


    /**
     * @return \Mollie_API_Client
     * @throws \Mollie_API_Exception
     */
    private function getMollieApi ()
    {
        if (!$this->mollieApi)
        {
            $this->mollieApi = new \Mollie_API_Client ();
            $apikey= ($this->getOption ('test_mode') == 0)? $this->getOption('live_api_key') : $this->getOption('test_api_key');
            $this->mollieApi->setApiKey($apikey);
        }
        return $this->mollieApi;
    }


}