<?php

/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/
namespace MotoStore\Payment\Payu;

use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\PhpEnvironment\Request;

class Payu extends PaymentModule
{

    private $_paymentUrl = 'https://secure.payu.com/api/v2_1/orders';
    private $_paymentUrlSandbox = 'https://secure.snd.payu.com/api/v2_1/orders';

    public function getName()
    {
        return 'Payu';
    }

    public function getImage()
    {
        return 'payu.png';
    }

    public function getDescription()
    {
        return '';
    }

    public function getHelpText()
    {
        return 'POS id and Second key (MD5) you can get from "Configuration Keys" section of PayU management panel';
    }

    public function setVariables()
    {
        $this
            ->addVariable (
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'PayU',
                    'required' => true,
                )
            )->addVariable (
                'pos_id',
                array(
                    'name' => 'Id POS (point of sales):',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )->addVariable (
                'key_md5',
                array(
                    'name' => 'Second key (MD5)',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => false,
                )
            )->addVariable (
                'test_mode',
                array(
                    'name' => 'Sandbox mode',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => 'The context mode of this module',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            )->addVariable (
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            );

    }

    /**
     * @param Order $order
     * @return mixed|void
     */
    public function checkout(Order $order)
    {
        $currency = $this->getCurrency ();
        $url= ($this->getOption ('test_mode') == 0)? $this->_paymentUrl : $this->_paymentUrlSandbox;
        $timestamp = time();

        foreach ($order->getProducts () as $k=>$product)
        {
            $data['products['.$k.'].name'] = $product->getName ();
            $data['products['.$k.'].quantity'] = $product->getQuantity ();
            $data['products['.$k.'].unitPrice'] = $product->getPrice ()*100;
        }
        $data['totalAmount'] = number_format ($order->getTotalPrice () * $currency->getExchangeRate (), 2, '.', '')*100;
        $data['currencyCode'] = strtoupper ($this->getCurrency()->getCode ());
        $data['merchantPosId'] = $this->getOption ('pos_id');
        $data['description'] = 'Order #' . $order->getOrderId ();
        $data['extOrderId'] = $order->getOrderId ();
        $data['customerIp'] = $_SERVER['REMOTE_ADDR'];



        $data['continueUrl'] = Link::storeLink('checkout', 'success', array('provider' => $this->getName(), 'motoorderid' => $order->getOrderId ()), false);
        $data['notifyUrl'] = Link::storeLink('checkout', 'success', array('provider' => $this->getName(), 'motoorderid' => $order->getOrderId ()), false);

        $data['OpenPayu-Signature'] = $this->getSignature($data) ;
        echo $this->form($url, $data);

    }

    public function handle(Request $request)
    {
        $this->getCart ()->setIsSuccess (true);
        if ($request->getQuery ('motoorderid')){
            $em = $this->serviceLocator->get ('MotoStore\EntityManager');
            $order = $this->getCurrentOrder ($request->getQuery ('motoorderid'));
            $request_body = file_get_contents("php://input");
            $request = json_decode($request_body,true);
            if (is_array($request) && isset($request['order'])){
                $ipnorder = $request['order'];
                if ( $ipnorder['status'] == 'COMPLETED')
                {
                    $status = Transaction::PAYMENT_STATUS_PAID;
                    $orderStatus = Order::ORDER_PAYMENT_ACCEPTED;
                    $this->getCart ()->setIsSuccess (true);
                    \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                }
                else
                {
                    $status = Transaction::PAYMENT_STATUS_PENDING;
                    $orderStatus = Order::ORDER_WAITING_PAYMENT;
                }

                $transaction = new Transaction ();
                $transaction->setOrder ($order);
                $transaction->setTransactionId (isset ($ipnorder ['orderId']) ? $ipnorder ['orderId'] : '');

                $date = new \DateTime ();
                $transaction->setDate ($date);
                $transaction->setPaymentMethod($this->getName ());
                $transaction->setStatus ($status);
                $transaction->setAdditional(json_encode ($request));
                $em->persist ($transaction);
                $order->addTransaction ($transaction);
                $order->setStatus ($orderStatus);
                $em->merge ($order);
                $em->flush ();

            }

        }

    }



    public function getSignature($params){
        $signature = "" ;
        $key = $this->getOption ('key_md5');

        ksort($params);
        foreach ($params as $n =>$val)
        {
            $signature .= $val;
        }
        $signature .= $key;
        $result = "sender=" . $this->getOption ('pos_id').";";
        $result .= "algorithm=MD5;";
        $result .= "signature=" . md5($signature) ;

        return $result ;
    }


}
