<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Payment\Skrill;


use MotoStore\Content\Helper\Link;
use MotoStore\Order\Entity\Order;
use MotoStore\Order\Entity\Product;
use MotoStore\Order\Entity\Transaction;
use MotoStore\Payment\Gateway\PaymentModule;
use Zend\Http\PhpEnvironment\Request;

class Skrill extends PaymentModule
{
    /**
     * Get payment processor
     *
     * @return string
     */
    public function getName ()
    {
        return 'Skrill';
    }

    /**
     * Get Payment Icon
     * @return string
     */
    public function getImage ()
    {
        return 'Skrill.jpg';
    }

    /**
     * description
     * @return string
     */
    public function getDescription ()
    {
        return '';
    }

    /**
     * Help text
     * @return string
     */
    public function getHelpText()
    {
        return "";
    }

    /**
     * Set Payment Variables Array
     * @return array
     */
    public function setVariables()
    {
        $this
            ->addVariable (
                self::OPTION_DISPLAY_NAME,
                array(
                    'name' => 'Display Name',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => 'Skrill',
                    'required' => true,
                )
            )
            ->addVariable (
                'email',
                array(
                    'name' => 'E-mail',
                    'type' => self::VARIABLE_TYPE_TEXT,
                    'help' => '',
                    'default' => '',
                    'required' => true,
                )
            )
            ->addVariable (
                'language',
                array(
                    'name' => 'Language',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 'EN',
                    'required' => true,
                    'options' => array (
                        'EN' => 'EN',
                        'DE' => 'DE',
                        'ES' => 'ES',
                        'FR' => 'FR',
                        'IT' => 'IT',
                        'PL' => 'PL',
                        'GR' => 'GR',
                        'RO' => 'RO',
                        'RU' => 'RU',
                        'TR' => 'TR',
                        'CN' => 'CN',
                        'CZ' => 'CZ',
                        'NL' => 'NL',
                        'DA' => 'DA',
                        'SV' => 'SV'
                    ),
                )
            )
            ->addVariable (
                self::OPTION_ENABLED,
                array(
                    'name' => 'Enabled',
                    'type' => self::VARIABLE_TYPE_SELECT,
                    'help' => '',
                    'default' => 0,
                    'required' => true,
                    'options' => array (
                        0 => 'No',
                        1 => 'Yes'
                    ),
                )
            );
    }

    /**
     * Handle Success
     *
     * @return mixed
     */
    public function handle (Request $request)
    {

        $order = $this->getCurrentOrder ($request->getPost('transaction_id', 0));
        $em = $this->serviceLocator->get ('MotoStore\EntityManager');

        if ($order)
        {
            $invoice_id     = $request->getQuery ('mb_transaction_id');
            $status         = (int) $request->getQuery ('status', -2);

            $transaction = new Transaction ();
            $transaction->setOrder ($order);
            $transaction->setTransactionId ($invoice_id);


            $date = new \DateTime ();


            $transaction->setDate ($date);
            $transaction->setPaymentMethod($this->getName ());

            switch ($status)
            {
                case 2:
                    $transactionStatus = Transaction::PAYMENT_STATUS_PAID;
                    $orderStatus = Order::ORDER_PAYMENT_ACCEPTED;
                    \Moto\Hook::trigger("MOTOSTORE_HOOK_ORDER_PAID",$order->getOrderId());
                    break;
                case 0:
                    $transactionStatus = Transaction::PAYMENT_STATUS_PENDING;
                    $orderStatus = Order::ORDER_STATUS_AWAITING_FULFILLMENT;
                    break;
                case -1:
                case -2:
                    $transactionStatus = Transaction::PAYMENT_STATUS_DECLINED;
                    $orderStatus = Order::ORDER_STATUS_CANCELED;
                    break;
                default:
                    $transactionStatus = Transaction::PAYMENT_STATUS_DECLINED;
                    $orderStatus = Order::ORDER_STATUS_CANCELED;
            }

            $transaction->setStatus ($transactionStatus);
            $order->setStatus ($orderStatus);

            $transaction->setAdditional(json_encode ($request->getQuery ()));

            $em->persist ($transaction);

            $order->addTransaction ($transaction);

            $em->merge ($order);
            $em->flush ();
            $this->getCart ()->setIsSuccess (true);
        }
    }

    /**
     * Proceed payment
     *
     * @param Order $order
     * @return mixed
     */
    public function checkout(Order $order)
    {
        $names = array_map (function (Product $p) {
            return $p->getName();
        }, $order->getProducts ()->toArray ());

        $data['pay_to_email'] = $this->getOption ('email');
        $data['language'] = $this->getOption('language', 'EN');
        $data['transaction_id'] = $order->getOrderId();
        $data['return_url'] = Link::storeLink ('checkout', 'success', array ('provider' => $this->getName ()), false);
        $data['cancel_url'] = Link::storeLink ('cart' , null, array(), false);
        $data['status_url'] = Link::storeLink ('checkout', 'success', array ('provider' => $this->getName ()), false);
        $data['prepare_only'] = 0;

        $data['firstname'] = $order->getFirstName();
        $data['lastname'] = $order->getLastName();
        $data['address'] = $order->getAddress1();
        $data['address2'] = $order->getAddress2();
        $data['phone_number'] = $order->getContactPhone();
        $data['postal_code'] = $order->getPostCode();
        $data['city'] = $order->getCity();
        $data['country'] = ($order->getCountry())?$order->getCountry()->getIso3():'';

        $data['amount'] = rtrim(rtrim($order->getTotalPrice (), '0'), '.');
        $data['currency'] = strtoupper ($this->getCurrency()->getCode ());
        $data['detail1_description'] = join(', ', $names);

        echo $this->form('https://pay.skrill.com', $data);
    }
}