<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Platform;

use MotoStore\Content\Helper\HookListener;
use MotoStore\Platform\Module\Manager;
use Zend\EventManager\EventManager;
use Zend\ServiceManager\Config;
use Zend\ServiceManager\ServiceManager;
use Moto;

class Application
{
    /**
     * Core Version
     */
    const CURRENT_VERSION = '1.5.7';

    /**
     * Core Build
     */
    const CURRENT_BUILD = '1571';

    /**
     * Private Store Config
     */
    const STORE_CONFIG          = 'store.config';

    /**
     * EventManager
     */
    const STORE_EVENT_MANAGER   = 'store.eventmanager';

    /**
     * @var ServiceManager
     */
    protected $serviceManager;

    /**
     * @var EventManager
     */
    protected $eventManager;

    /**
     *
     * @var array
     */
    protected $applicationConfig = array ();


    /** @var  Application */
    private static $instance;

    /**
     * @param array $applicationConfig
     */
    public static function run ($applicationConfig)
    {

        if (!static::$instance)
        {
            static::$instance = new self;
            static::$instance->applicationConfig = $applicationConfig;

                try
                {
                    static::$instance->attachHookListeners ();
                    static::$instance->registerServiceManager ();
                    static::$instance->registerEventManager ();

                    static::$instance->attachModules (static::$instance->applicationConfig ['store.modules']);

                    static::$instance
                        ->eventManager
                        ->trigger ('store.event.modules.loaded');


                }
                catch (\Exception $e)
                {
                    error_log (__FILE__ . ' ' . $e->getMessage ());
                    error_log ($e->getTraceAsString ());
                }
        }
        return static::$instance;
    }

    /**
     * Register Store Event Manager
     */
    public function registerEventManager ()
    {
        $this->eventManager = new EventManager ();

        $this
            ->getServiceManager ()
            ->setService (self::STORE_EVENT_MANAGER, $this->eventManager);
    }


    /**
     * Attach Defined Modules
     *
     * @param $modules
     */
    public function attachModules ($modules)
    {
        /** @var Manager $moduleManager */
        $moduleManager = $this
            ->getServiceManager ()
            ->get ('store.module.manager');

        $moduleManager->setModulesConfigs ($this->applicationConfig);

        foreach ($modules as $module)
        {
            $moduleManager->attachModule ($module);
        }
        $moduleManager->applyServices ();
    }


    /**
     * @return ServiceManager
     */
    public function getServiceManager ()
    {
        return $this->serviceManager;
    }


    /**
     * Create Service Manager With Base Services
     */
    public function registerServiceManager ()
    {
        $serviceManagerConfig = null;

        if (isset ($this->applicationConfig ['service_manager']))
        {
            $serviceManagerConfig = new Config ($this->applicationConfig ['service_manager']);
            // Unset Registered
            unset ($this->applicationConfig ['service_manager']);
        }
        $this->serviceManager = new ServiceManager ($serviceManagerConfig);
    }

    public  function  attachHookListeners () {
        HookListener::attachHookListeners();
    }
}
