<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Auth;

use Zend\Authentication\Storage\Session as SessionStorage;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;


class AuthenticationService implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $service = new \Zend\Authentication\AuthenticationService ();

        $storage = new SessionStorage ('MotoStore_Auth', null);
        $adapter = new DoctrineAdapter ();

        $adapter
            ->setEntityManager ($serviceLocator->get ('MotoStore\EntityManager'));

        $service
            ->setStorage ($storage)
            ->setAdapter ($adapter);

        return $service;
    }
}