<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Platform\Controller;


use Moto\Application\Pages\PageModel;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Platform\Route\RoutableInterface;
use MotoStore\Content\Helper\Link;

abstract  class AbstractController
{
    /** @var  PageModel */
    protected $page;

    public function __construct ($page = null)
    {
        $this->page = $page;
    }

    /**
     * @var \Zend\Http\PhpEnvironment\Request
     */
    private $request;
    /**
     * @return \Zend\ServiceManager\ServiceLocatorInterface
     */
    public function getServiceLocator ()
    {
        return SMStatic::getInstance ();
    }

    /**
     * @return \Zend\Http\PhpEnvironment\Request
     */
    public function getRequest ()
    {
        if (!$this->request)
        {
            $this->request = new \Zend\Http\PhpEnvironment\Request();
        }

        return $this->request;

    }

    /**
     * Bind real url for virtual pages based on
     * template
     * @param $entity
     * @param $section
     */
    protected function bindUrl ($entity = null, $section = null)
    {
        if ($entity instanceof RoutableInterface)
        {
            $this->page->relative_url = ltrim (Link::storeLink($section, $entity->getUri()), '/');
        }
        else
        {
            $this->page->relative_url = ltrim (Link::storeLink($section), '/');
        }
    }
}