<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Doctrine\Listener;


use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Mapping\ClassMetadataInfo;

/**
 * DoctrineExtension
 * Register Prefix Foe ClassMetadata
 *
 * Class DoctrineTablePrefixListener
 * @package MotoStore\Platform\Doctrine\Listener
 */
class DoctrineTablePrefixListener
{
    /**
     * @var string
     */
    protected  $tablePrefix;

    /**
     * @param $tablePrefix
     */
    public function __construct ($tablePrefix)
    {
        $this->tablePrefix = $tablePrefix;
    }

    /**
     * On LoadMetaData Callback
     *
     * @param LoadClassMetadataEventArgs $args
     */
    public function loadClassMetaData (LoadClassMetadataEventArgs $args)
    {
        /**
         * @var ClassMetadataInfo $classMetadata
         */
        $classMetadata = $args->getClassMetadata ();

        if (!$classMetadata->isInheritanceTypeSingleTable () || $classMetadata->getName () === $classMetadata->rootEntityName)
        {
            $classMetadata->setTableName ((string) $this->tablePrefix . $classMetadata->getTableName ());
        }

        foreach ($classMetadata->getAssociationMappings() as $fieldName => $mapping)
        {
            if ($mapping['type'] == \Doctrine\ORM\Mapping\ClassMetadataInfo::MANY_TO_MANY)
            {
                $mappedTableName = $classMetadata->associationMappings [$fieldName] ['joinTable'] ['name'];
                $classMetadata->associationMappings [$fieldName] ['joinTable'] ['name'] = (string) $this->tablePrefix . $mappedTableName;
            }
        }
    }
}