<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Platform\Doctrine\Service;


use Doctrine\Common\EventManager;
use Doctrine\ORM\Configuration;
use Doctrine\ORM\Events;
use MotoStore\Platform\Doctrine\Cache\AnnotationCachePattern;
use MotoStore\Platform\Doctrine\Listener\DoctrineTablePrefixListener;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;
use Moto;

class EntityManagerFactory implements FactoryInterface
{
    /**
     * Create service
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $resource       = $this->getMotoCMSPDOResource ();
        $storeConfig    = $serviceLocator->get ('store.config');
        $sharedConfig   = $serviceLocator->get ('store.motocms.config');

        $options = array ('driver' => $storeConfig ['Doctrine']['driver'], 'pdo' => $resource);

        /** @var EntityManager $entityManager */
        $entityManager =  EntityManager::create ($options, $this->getDoctrineConfiguration ($storeConfig));

        if (!empty ($sharedConfig ['database']['prefix']))
        {
            $entityManager->setTablePrefix ($sharedConfig ['database']['prefix']);
            $this->attachTablePrefixListener ($sharedConfig ['database']['prefix'], $entityManager->getEventManager());
        }
        return $entityManager;
    }

    /**
     * Attach TablePrefix Listener
     *
     * @param $tablePrefix
     * @param EventManager $eventManager
     */
    protected function attachTablePrefixListener ($tablePrefix, EventManager $eventManager)
    {
        $listener = new DoctrineTablePrefixListener ($tablePrefix);

        $eventManager->addEventListener (Events::loadClassMetadata, $listener);
    }


    /**
     * @param $storeConfig
     * @return Configuration
     */
    protected function getDoctrineConfiguration ($storeConfig)
    {
        $paths = isset ($storeConfig['Entities'])
            ? array_values($storeConfig['Entities'])
            : array ();

        $cache  = new AnnotationCachePattern (Moto\System::getAbsolutePath($storeConfig ['Doctrine'] ['annotationDirectory']));
        $config = new Configuration ();

        $config->setMetadataDriverImpl  ($config->newDefaultAnnotationDriver ($paths, false));
        $config->setProxyDir            ($storeConfig ['Doctrine'] ['proxyDirectory']);
        $config->setProxyNamespace      ($storeConfig ['Doctrine'] ['proxyNamespace']);
        $config->setAutoGenerateProxyClasses ($storeConfig ['Doctrine'] ['proxyAutoGenerate']);
        $config->setMetadataCacheImpl   ($cache);


//        $config->setQueryCacheImpl($cache);
//        $config->setResultCacheImpl($cache);
//        $config->setHydrationCacheImpl($cache);

        return $config;
    }

    /**
     * @return \PDO
     */
    private function getMotoCMSPDOResource ()
    {
        $motoDbAdapter = \Moto\Config::get ('databaseAdapter');

        return $motoDbAdapter
            ->getDriver ()
            ->getConnection()
            ->getResource ();
    }
}