<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Media
 * @package MotoStore\Platform\Entity
 * @ORM\Entity(readOnly=true)
 * @ORM\Table(name="media_items",options={"engine":"InnoDB"})
 */
class Media
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string") */
    protected $name;

    /** @ORM\Column(type="string") */
    protected $alt;

    /** @ORM\Column(type="string") */
    protected $title;

    /** @ORM\Column(type="string") */
    protected $path;

    /** @ORM\Column(type="string") */
    protected $thumbnails;

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getName ()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getAlt ()
    {
        return $this->alt;
    }
    /**
     * @return mixed
     */
    public function getTitle ()
    {
        return $this->title;
    }

    /**
     * @param mixed $name
     */
    public function setName ($name)
    {
        $this->name = $name;
    }
    /**
     * @return mixed
     */
    public function getThumbnails ()
    {
        return $this->thumbnails;
    }

    /**
     * @param mixed $name
     */
    public function setThumbnails ($thumbnails)
    {
        $this->name = $thumbnails;
    }

    /**
     * @return mixed
     */
    public function getPath ()
    {
        return $this->path;
    }

    /**
     * @param mixed $path
     */
    public function setPath ($path)
    {
        $this->path = $path;
    }
}