<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/


namespace MotoStore\Platform\Form\Filter;


use Zend\Filter\AbstractFilter;
use Zend\Filter\Exception;

class DefaultValue extends AbstractFilter
{
    protected $default;

    /**
     * @param $default
     */
    function __construct ($default)
    {
        $this->default = $default;
    }


    /**
     * @return mixed
     */
    public function getDefault ()
    {
        return $this->default;
    }

    /**
     * @param mixed $default
     */
    public function setDefault ($default)
    {
        $this->default = $default;
    }

    /**
     * Returns the result of filtering $value
     *
     * @param  mixed $value
     * @throws Exception\RuntimeException If filtering $value is impossible
     * @return mixed
     */
    public function filter ($value)
    {
        if (!$value)
        {
            $value = $this->default;
        }

        return $value;
    }
}