<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Platform\Form;


use Doctrine\ORM\EntityManager;
use Zend\InputFilter\InputFilter;
use Zend\Stdlib\Hydrator\ClassMethods;
use Zend\Stdlib\Hydrator\HydrationInterface;

abstract class FormTypeAbstract extends InputFilter
{
    /**
     * @var EntityManager
     */
    private $entityManager;

    /**
     * @var HydrationInterface
     */
    protected $hydrator;

    public function __construct ()
    {
        $this->createHydrator ();
    }

    /**
     * @return EntityManager
     */
    public function getEntityManager ()
    {
        return $this->entityManager;
    }

    /**
     * @param EntityManager $entityManager
     * @return $this
     */
    public function setEntityManager ($entityManager)
    {
        $this->entityManager = $entityManager;

        return $this;
    }

    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected abstract function getStrategies ();


    /**
     * Form Handler
     *
     * @param $data
     * @param $entity
     * @return bool
     */
    public function handle ($data, $entity)
    {
        $this->onPresetData ($data, $entity);

        $this->setData ($data);

        if ($this->isValid ())
        {

            $this
                ->hydrator
                ->hydrate ($this->getValues (), $entity);

            $this
                ->onDataValid ($this->data, $entity);

            $this
                ->onSuccess ($entity);

            return true;
        }
        return false;
    }


    /**
     * On success validation
     *
     * @param $entity
     */
    protected function onSuccess ($entity)
    {
        $entity->getId ()
            ? $this->entityManager->merge ($entity)
            : $this->entityManager->persist ($entity);

        $this->entityManager->flush ();
    }


    /**
     * On data preset
     *
     * @param $data
     * @param $entity
     */
    protected function onPresetData (&$data, $entity)
    {
    }


    /**
     * On data Valid
     *
     * @param $data
     * @param $entity
     */
    protected function onDataValid (&$data, $entity)
    {
    }

    /**
     * Create form hydrator
     */
    protected function createHydrator ()
    {
        $this->hydrator = new ClassMethods ();

        foreach ($this->getStrategies () as $strategyName => $strategy)
        {
            $this->hydrator->addStrategy ($strategyName, $strategy);
        }
    }

}