<?php
/**
 * Created by PhpStorm.
 * User: pirog
 * Date: 20.09.2017
 * Time: 15:37
 */


namespace MotoStore\Platform\Integrations\QuickBooks;




use Moto;
use MotoStore;
use MotoStore\Customer\Entity\Customer;
use MotoStore\Order\Entity\Order;
use MotoStore\Settings\Entity\Option;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Settings\Repository\OptionRepository;


class QuickBooks
{
    const API_URL = 'https://quickbooks.api.intuit.com/v3';

    public static function addCustomer(Customer $customer = null){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $companyid =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_company_id');
        $access_token = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_access_token');
        if (!$access_token || empty($access_token))
            return false;
        $http_headers['Content-Type'] = 'application/json';
        $http_headers['Authorization'] = 'OAuth ' . $access_token;
        $data = array(
            'BillAddr' => array(
                'Line1' => $customer->getAddress1(),
                'City' => $customer->getCity(),
                'Country' => $customer->getCountry()->getName(),
                'CountrySubDivisionCode' => $customer->getCountry()->getIso2(),
                'PostalCode' => $customer->getPostCode()
            ),
            'Notes' => "",
            'Title' => '',
            "MiddleName" => "",
            "GivenName" => $customer->getFirstName(),
            "FamilyName" => $customer->getLastName(),
            "Suffix" => "",
            "FullyQualifiedName" => $customer->getFullName(),
            "CompanyName" => $customer->getCompany(),
            "DisplayName" => $customer->getFullName(),
            "PrimaryPhone" => array(
                "FreeFormNumber" => $customer->getContactPhone(),
            ),
            "PrimaryEmailAddr"=>array(
                "Address" => $customer->getEmail()
            )
        );

        $data = json_encode($data);
        $http_headers['Content-Length'] = strlen($data);
        $url = self::API_URL . '/company/' . $companyid . '/customer';

        MotoStore\Platform\Integrations\QuickBooks\Request::executeRequest($url, json_encode($data), "POST", $http_headers);

    }

    public static function addPurchase(Order $order = null){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $companyid =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_company_id');
        $access_token = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_access_token');
        if (!$access_token || empty($access_token))
            return false;

        $http_headers['Content-Type'] = 'application/json';
        $http_headers['Authorization'] = 'OAuth ' . $access_token;

        $data = array(
            "AccountRef"=>array(
                "value"=> '',
                "name"=> ""
            ),
            "PaymentType"=> $order->getPaymentGateway(),
            "Line" => array (
                array(
                    "Amount"=> $order->getTotalPrice(),
                    "DetailType"=> "AccountBasedExpenseLineDetail",
                    "AccountBasedExpenseLineDetail"=>
                        array(
                            "AccountRef"=> array(
                            "name" => $order->getProducts()->first()->getName(),
                            "value" => ""
                        )
                    )
                ),
            ),
        );

        $data = json_encode($data);
        $http_headers['Content-Length'] = strlen($data);
        $url = self::API_URL . '/company/' . $companyid . '/purchase';
        MotoStore\Platform\Integrations\QuickBooks\Request::executeRequest($url, json_encode($data), "POST", $http_headers);
    }
}