<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Category implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('c', 'i', 'l','p','pr','prv','b','br'))
            ->from ('MotoStore\Product\Entity\Category', 'c')
            ->leftJoin ('c.image', 'i')
            ->leftJoin ('c.locales', 'l')
            ->leftJoin ('c.properties', 'p')
            ->leftJoin ('p.property', 'pr')
            ->leftJoin ('pr.values', 'prv')
            ->leftJoin ('c.brands', 'b')
            ->leftJoin ('b.brand', 'br')
            ->orderBy('c.order', 'ASC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'parent_id'             => 'c.parent_id',
            'uri'                   => 'c.uri',
            'order'                 => 'c.order',
            'language_code'         => 'l.language_code',
            'name'                  => 'l.name',
            'meta_keywords'         => 'l.meta_description',
            'short_description'     => 'l.short_description',
            'description'           => 'l.description',
        ));

        return $collection;
    }
}