<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Product implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array (
                'p',
                'c',
                'l',
                'b',
                'pr',
                'pi',
                'pf',
                'i',
                'tp',
                'rp',
                'pco',
                'pv',
                'r'
            ))
            ->from ('MotoStore\Product\Entity\Product', 'p')
            ->leftJoin ('p.relations', 'r')
            ->leftJoin ('p.related', 'rp')
            ->leftJoin ('p.locales', 'l')
            ->leftJoin ('p.categories', 'c')
            ->leftJoin ('p.brand', 'b')
            ->leftJoin ('p.image', 'pi')
            ->leftJoin ('p.file', 'pf')
            ->leftJoin ('p.images', 'i')
            ->leftJoin ('p.tier_prices', 'tp')
            ->leftJoin ('p.properties', 'pr')
            ->leftJoin ('p.custom_options', 'pco')
            ->leftJoin ('p.variants', 'pv')
            ->orderBy('p.id', 'DESC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'id'                    => 'p.id',
            'sku'                   => 'p.sku',
            'upc'                   => 'p.upc',
            'price'                 => 'p.price',
            'badge'                 => 'p.badge',
            'uri'                   => 'p.uri',
            'quantity'              => 'p.quantity',
            'btob'                  => 'p.btob',
            'visibility'            => 'p.visibility',
            'rating'                => 'p.rating',
            'special_price'         => 'p.special_price',
            'has_special_price'     => 'p.has_special_price',
            'name'                  => 'l.name',
            'keywords'              => 'l.keywords',
            'category_id'           => 'r.category_id',
            'created_date'          => 'p.created_date',
            'video_uri'             => 'p.video_uri',
            'brand_id'             => 'b.id',
        ));

        return $collection;
    }
}