<?php

namespace MotoStore\Product\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class ProductCatalogFilter implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array (
                'p',
                'c',
                'l',
                'b',
                'pi',
                'r',
                'pr',
            ))
            ->from ('MotoStore\Product\Entity\Product', 'p')
            ->leftJoin ('p.relations', 'r')
            ->leftJoin ('p.locales', 'l')
            ->leftJoin ('p.categories', 'c')
            ->leftJoin ('p.brand', 'b')
            ->leftJoin ('p.image', 'pi')
            ->leftJoin ('p.properties', 'pr')
            ->orderBy('p.created_date', 'DESC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'id'                    => 'p.id',
            'sku'                   => 'p.sku',
            'upc'                   => 'p.upc',
            'price'                 => 'p.price',
            'badge'                 => 'p.badge',
            'uri'                   => 'p.uri',
            'quantity'              => 'p.quantity',
            'btob'                  => 'p.btob',
            'visibility'            => 'p.visibility',
            'rating'                => 'p.rating',
            'special_price'         => 'p.special_price',
            'has_special_price'     => 'p.has_special_price',
            'name'                  => 'l.name',
            'category_id'           => 'r.category_id',
            'created_date'          => 'p.created_date',
        ));

        return $collection;
    }
}