<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Variant implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select(array ('v', 'i', 'vo', 'vv', 'o'))
            ->from ('MotoStore\Product\Entity\Variant', 'v')
            ->leftJoin ('v.image', 'i')
            ->leftJoin ('v.options', 'vo')
            ->leftJoin ('vo.option', 'o')
            ->leftJoin ('vo.value', 'vv')
            ->orderBy('v.id', 'ASC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'id'                    => 'v.id',
            'product_id'            => 'v.product_id',
            'sku'                   => 'v.sku',
        ));

        return $collection;
    }
}