<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/


namespace MotoStore\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Platform\Entity\Media;
use MotoStore\Platform\Route\RoutableInterface;


/**
 * @ORM\Entity()
 * @ORM\Table(name="store_brand",options={"engine":"InnoDB"})
 */
class Brand implements RoutableInterface
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string") */
    protected $name;

    /** @ORM\Column(type="text") */
    protected $description;

    /** @ORM\Column(type="string") */
    protected $uri;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Platform\Entity\Media")
     * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="SET NULL")
     *
     */
    protected $image;

    /**
     * @var ArrayCollection
     * @ORM\OneToMany(targetEntity="Product", mappedBy="brand")
     */
    private $products;

    public function __construct()
    {
        $this->products = new ArrayCollection();
    }

    /**
     * @param mixed $product
     */
    public function addProduct ($product)
    {
        $this->products = $product;
    }

    /**
     * @return ArrayCollection
     */
    public function getProducts ()
    {
        return $this->products;
    }

    /**
     * @param mixed $brand_description
     */
    public function setDescription ($brand_description)
    {
        $this->description = $brand_description;
    }

    /**
     * @return mixed
     */
    public function getDescription ()
    {
        return $this->description;
    }

    /**
     * @param mixed $name
     */
    public function setName ($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getName ()
    {
        return $this->name;
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @return mixed
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * @param mixed $uri
     */
    public function setUri($uri)
    {
        $this->uri = $uri;
    }

    /**
     * @param Media $media
     */
    public function attachImage (Media $media = null)
    {
        $this->image = $media;
    }
}