<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use MotoStore\Platform\Entity\Media;
use MotoStore\Platform\Locale\LocaleAwareInterface;
use MotoStore\Platform\Route\RoutableInterface;
use MotoStore\Product\Entity\Category\Locale;
use MotoStore\Product\Entity\CategoryProperty\Relation as PropertyRelation;
use MotoStore\Product\Entity\CategoryBrand\Relation as BrandRelation;

/**
 * @ORM\Entity()
 * @ORM\Table(name="store_category",options={"engine":"InnoDB"})
 * @ORM\Entity(repositoryClass="MotoStore\Product\Repository\CategoryRepository")
 */
class Category implements LocaleAwareInterface, RoutableInterface
{
    const ZERO_PARENT = 0;

    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $parent_id;

    /**
     * @ORM\Column(type="integer", name="`order`")
     */
    protected $order = 0;

    /** @ORM\Column(type="boolean",nullable=true) */
    protected $btob = false;

    /**
     * @ORM\Column(type="string")
     */
    protected $uri;

    /**
     * @ORM\OneToMany(
     *  targetEntity="MotoStore\Product\Entity\Category\Locale",
     *  mappedBy="category",
     *  indexBy="language_code",
     *  cascade={"persist", "remove", "merge"}
     * )
     */
    protected $locales;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Platform\Entity\Media")
     * @ORM\JoinColumn(name="image_id", referencedColumnName="id", onDelete="SET NULL")
     *
     */
    protected $image;

    /**
     * @ORM\OneToMany(
     *  targetEntity="MotoStore\Product\Entity\CategoryBrand\Relation", mappedBy="category", cascade={"persist", "remove"},
     *  orphanRemoval=true
     * )
     */
    protected $brands;


    /**
     * @ORM\OneToMany(
     *  targetEntity="MotoStore\Product\Entity\CategoryProperty\Relation", mappedBy="category", cascade={"persist", "remove"},
     *  orphanRemoval=true
     * )
     */
    protected $properties;



    public function __construct ()
    {
        $this->products = new ArrayCollection ();
        $this->locales  = new ArrayCollection ();
        $this->properties  = new ArrayCollection ();
        $this->brands  = new ArrayCollection ();
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $parent_id
     */
    public function setParentId ($parent_id)
    {
        $this->parent_id = $parent_id;
    }

    /**
     * @return mixed
     */
    public function getParentId ()
    {
        return $this->parent_id;
    }

       /**
     * @return mixed
     */
    public function getOrder ()
    {
        return $this->order;
    }

    /**
     * @param mixed $order
     */
    public function setOrder ($order)
    {
        $this->order = $order;
    }

    /**
     * @return mixed
     */
    public function getBtob ()
    {
        return $this->btob;
    }

    /**
     * @param mixed $btob
     */
    public function setBtob ($btob)
    {
        $this->btob = $btob;
    }


    /**
     * @param Locale $locales
     */
    public function addLocale (Locale $locales)
    {
        $this->locales->add ($locales);
    }

    /**
     * @return ArrayCollection
     */
    public function getLocales ()
    {
        return $this->locales;
    }

    /**
     * @param string $uri
     */
    public function setUri ($uri)
    {
        $this->uri= $uri;
    }

    /**
     * @return mixed
     */
    public function getUri ()
    {
        return $this->uri;
    }

    /**
     * @return Media
     */
    public function getImage ()
    {
        return $this->image;
    }

    /**
     * @param mixed $image
     */
    public function attachImage ($image = null)
    {
        $this->image = $image;
    }

    /**
     * @param $code
     * @return Locale
     */
    public function getLocaleByLanguageCode ($code)
    {

        $code = strtolower ($code);

        foreach ($this->getLocales() as $locale)
        {
            if (strtolower ($locale->getLanguageCode ()) == $code)
            {
                return $locale;
            }
        }
        return new Locale ($code);
    }

    /**
     * @return ArrayCollection
     */
    public function getProperties ()
    {
        return $this->properties;
    }

    /**
     * @param $property
     */
    public function addProperty ($property)
    {
        $this->properties->add ($property);
    }

    public function removeProperty (PropertyRelation $relation)
    {
        $this->properties->removeElement ($relation);
    }

    /**
     * @return ArrayCollection
     */
    public function getBrands ()
    {
        return $this->brands;
    }

    public function addBrand ($brand)
    {
        $this->brands->add ($brand);
    }

    public function removeBrand (BrandRelation $relation)
    {
        $this->brands->removeElement ($relation);
    }
}