<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity\Product;

use Doctrine\ORM\Mapping as ORM;
use MotoStore\Platform\Locale\LocaleInterface;
use MotoStore\Product\Entity\Product;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_locale",options={"engine":"InnoDB"})
 */
class Locale implements LocaleInterface
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $product_id;

    /** @ORM\Column(type="string") */
    protected $language_code;

    /** @ORM\Column(type="string") */
    protected $name;

    /** @ORM\Column(type="string", nullable=true) */
    protected $keywords;

    /** @ORM\Column(type="string", nullable=true) */
    protected $meta_description;

    /** @ORM\Column(type="string", nullable=true) */
    protected $meta_title;


    /** @ORM\Column(type="string", nullable=true) */
    protected $og_title;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_description;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_url;

    /** @ORM\Column(type="string", nullable=true) */
    protected $og_image;


    /** @ORM\Column(type="text", nullable=true) */
    protected $canonical_url;

    /** @ORM\Column(type="text", nullable=true) */
    protected $short_description;

    /** @ORM\Column(type="text", nullable=true) */
    protected $description;

    /** @ORM\Column(type="boolean") */
    protected $noindex = false;

    /** @ORM\Column(type="boolean") */
    protected $nofollow = false;

    /** @ORM\Column(type="boolean") */
    protected $hide_canonical = false;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product", inversedBy="locales")
     * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
     */
    protected $product;

    /**
     * @param null $language_code
     */
    public function __construct ($language_code=null)
    {
        if ($language_code)
        {
            $this->setLanguageCode ($language_code);
        }

    }
    public function __clone ()
    {
        $this->name = $this->name . ' - Copy';
    }

    /**
     * @param int $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $product_id
     */
    public function setProductId ($product_id)
    {
        $this->product_id = $product_id;
    }

    /**
     * @return mixed
     */
    public function getProductId ()
    {
        return $this->product_id;
    }

    /**
     * @param $code
     * @return mixed|void
     * @internal param string $language_code
     */
    public function setLanguageCode ($code)
    {
        $this->language_code = $code;
    }

    /**
     * @return string
     */
    public function getLanguageCode ()
    {
        return $this->language_code;
    }

    /**
     * @param string $description
     */
    public function setDescription ($description)
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription ()
    {
        return $this->description;
    }
    /**
     * @param string $meta_title
     */
    public function setMetaTitle ($meta_title)
    {
        $this->meta_title = $meta_title;
    }

    /**
     * @return string
     */
    public function getMetaTitle ()
    {
        return $this->meta_title;
    }
    /**
     * @param string $og_title
     */
    public function setOgTitle ($og_title)
    {
        $this->og_title = $og_title;
    }

    /**
     * @return string
     */
    public function getOgTitle ()
    {
        return $this->og_title;
    }

    /**
     *
     * @param string $og_url
     */
    public function setOgUrl ($og_url)
    {
        $this->og_url = $og_url;
    }

    /**
     * @return string
     */
    public function getOgUrl ()
    {
        return $this->og_url;
    }

    /**
     *
     * @param string $og_description
     */
    public function setOgDescription ($og_description)
    {
        $this->og_description = $og_description;
    }

    /**
     * @return string
     */
    public function getOgDescription ()
    {
        return $this->og_description;
    }

    /**
     *
     * @param string $og_image
     */
    public function setOgImage ($og_image)
    {
        $this->og_image = $og_image;
    }

    /**
     * @return string
     */
    public function getOgImage ()
    {
        return $this->og_image;
    }

    /**
     * @param string $canonical_url
     */
    public function setCanonicalUrl ($canonical_url)
    {
        $this->canonical_url = $canonical_url;
    }

    /**
     * @return string
     */
    public function getCanonicalUrl ()
    {
        return $this->canonical_url;
    }

    /**
     * @param string $keywords
     */
    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;
    }

    /**
     * @return string
     */
    public function getKeywords ()
    {
        return $this->keywords;
    }

    /**
     * @param string $meta_description
     */
    public function setMetaDescription ($meta_description)
    {
        $this->meta_description = $meta_description;
    }

    /**
     * @return string
     */
    public function getMetaDescription ()
    {
        return $this->meta_description;
    }

    /**
     * @param string $name
     */
    public function setName ($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName ()
    {
        return $this->name;
    }

    /**
     * @param string $short_description
     */
    public function setShortDescription ($short_description)
    {
        $this->short_description = $short_description;
    }

    /**
     * @return string
     */
    public function getShortDescription ()
    {

        return $this->short_description;
    }

    /**
     * @param Product $product
     */
    public function setProduct (Product $product)
    {
       $this->product = $product;
    }

    /**
     * @param bool $noindex
     */
    public function setNoindex ($noindex)
    {
        $this->noindex = $noindex;
    }


    /**
     * @return mixed
     */
    public function getNoindex ()
    {
        return $this->noindex;
    }

    /**
     * @param bool $nofollow
     */
    public function setNofollow ($nofollow)
    {
        $this->nofollow = $nofollow;
    }


    /**
     * @return mixed
     */
    public function getNofollow ()
    {
        return $this->nofollow;
    }

    /**
     * @param bool $hide_canonical
     */
    public function setHideCanonical ($hide_canonical)
    {
        $this->hide_canonical = $hide_canonical;
    }


    /**
     * @return mixed
     */
    public function getHideCanonical ()
    {
        return $this->hide_canonical;
    }
}