<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity\Property;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_property_value",options={"engine":"InnoDB"})
 */
class Value
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $property_id;

    /**
     * @ORM\Column(type="string")
     */
    protected $value;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Property", inversedBy="values")
     * @ORM\JoinColumn(name="property_id", referencedColumnName="id")
     */
    protected $property;

    /**
     * @return mixed
     */
    public function getId ()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId ($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getProperty ()
    {
        return $this->property;
    }

    /**
     * @param mixed $property
     */
    public function setProperty ($property)
    {
        $this->property = $property;
    }

    /**
     * @return mixed
     */
    public function getPropertyId ()
    {
        return $this->property_id;
    }

    /**
     * @param mixed $property_id
     */
    public function setPropertyId ($property_id)
    {
        $this->property_id = $property_id;
    }

    /**
     * @return string
     */
    public function getValue ()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     */
    public function setValue ($value)
    {
        $this->value = $value;
    }
}