<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_related",options={"engine":"InnoDB"}) */
class Related
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $main_product_id;

    /** @ORM\Column(type="string") */
    protected $name;

    /** @ORM\Column(type="integer", nullable=true) */
    protected $product_id;


    /** @ORM\Column(type="string", nullable=true) */
    protected $sku;

    /** @ORM\Column(type="string", nullable=true) */
    protected $image;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $price;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Product")
     * @ORM\JoinColumn(name="main_product_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $main_product;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getProductId ()
    {
        return $this->product_id;
    }

    /**
     * @param mixed $product_id
     */
    public function setProductId ($product_id)
    {
        $this->product_id = $product_id;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getSku()
    {
        return $this->sku;
    }

    /**
     * @param mixed $sku
     */
    public function setSku($sku)
    {
        $this->sku = $sku;
    }
 /**
     * @return mixed
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * @param mixed $sku
     */
    public function setImage($image)
    {
        $this->image = $image;
    }

    /**
     * @return mixed
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param mixed $price
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }


    /**
     * @return \MotoStore\Product\Entity\Product
     */
    public function getMainProduct ()
    {
        return $this->main_product;
    }

    /**
     * @param \MotoStore\Product\Entity\Product $product
     */
    public function setMainProduct ($product)
    {
        $this->main_product = $product;
    }



}