<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Entity\Variant;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="store_product_variant_option",options={"engine":"InnoDB"})
 */
class VariantOption
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $variant_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $option_id;

    /**
     * @ORM\Column(type="integer")
     */
    protected $value_id;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Option", cascade={"persist"})
     * @ORM\JoinColumn(name="option_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\Option
     */
    protected $option;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\OptionValue")
     * @ORM\JoinColumn(name="value_id", referencedColumnName="id")
     * @var \MotoStore\Product\Entity\OptionValue
     */
    protected $value;

    /**
     * @ORM\ManyToOne(targetEntity="MotoStore\Product\Entity\Variant", inversedBy="options")
     * @ORM\JoinColumn(name="variant_id", referencedColumnName="id", onDelete="CASCADE")
     * @var \MotoStore\Product\Entity\Variant
     */
    protected $variant;


    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getVariantId()
    {
        return $this->variant_id;
    }

    /**
     * @param mixed $variant_id
     */
    public function setVariantId($variant_id)
    {
        $this->variant_id = $variant_id;
    }

    /**
     * @return mixed
     */
    public function getOptionId()
    {
        return $this->option_id;
    }

    /**
     * @param mixed $option_id
     */
    public function setOptionId($option_id)
    {
        $this->option_id = $option_id;
    }

    /**
     * @return \MotoStore\Product\Entity\Option
     */
    public function getOption()
    {
        return $this->option;
    }

    /**
     * @param \MotoStore\Product\Entity\Option $option
     */
    public function setOption($option)
    {
        $this->option = $option;
    }

    /**
     * @return \MotoStore\Product\Entity\Variant
     */
    public function getVariant()
    {
        return $this->variant;
    }

    /**
     * @param \MotoStore\Product\Entity\Variant $variant
     */
    public function setVariant($variant)
    {
        $this->variant = $variant;
    }

    /**
     * @return mixed
     */
    public function getValueId()
    {
        return $this->value_id;
    }

    /**
     * @param mixed $value_id
     */
    public function setValueId($value_id)
    {
        $this->value_id = $value_id;
    }

    /**
     * @return \MotoStore\Product\Entity\OptionValue
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param \MotoStore\Product\Entity\OptionValue $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }
}