<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Form\FormTypeAbstract;

class CategoryLocaleType extends FormTypeAbstract
{
    public function init()
    {
        $this
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 1,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'keywords',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'meta_description',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array (
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'short_description',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 500,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'description',
                'filters'  => array(
                    array ('name' => 'StripTags'),
                    array ('name' => 'StringTrim'),
                ),
                'required'  => false,
                'validators'=> array (
                ),
            ));
    }

    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array ();
    }


}