<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Doctrine\Strategy\DateTimeStrategy;
use MotoStore\Platform\Doctrine\Strategy\LocalesStrategy;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\MediaRelation;
use MotoStore\Product\Entity\Option;
use MotoStore\Product\Entity\OptionValue;
use MotoStore\Product\Entity\CustomOption;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Entity\Property\Relation;
use MotoStore\Product\Entity\Related;
use MotoStore\Product\Entity\TierPrice;
use MotoStore\Product\Entity\Variant;
use Zend\InputFilter\CollectionInputFilter;
use Zend\Json\Server\Error;

class ProductType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
            'special_date_start'    => new DateTimeStrategy (),
            'special_date_end'      => new DateTimeStrategy (),
            'created_date'          =>new DateTimeStrategy(),
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $locales = new CollectionInputFilter ();

        $localeType = new LocaleType ();
        $localeType
            ->setEntityManager ($this->getEntityManager ())
            ->init ();

        $locales
            ->setInputFilter ($localeType);

        $zero = new DefaultValue (0);

        $this
            ->add (array (
                'name'      => 'id',
                'required'  => false,
            ))
            ->add (array (
                'name'      => 'sku',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'badge',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'upc',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 128,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'uri',
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 256,
                        )
                    ),
                    array (
                        'name' => 'MotoStore\Platform\From\Validator\Unique',
                        'options' => array (
                            'entityManager' => $this->getEntityManager (),
                            'entity'        => 'MotoStore\Product\Entity\Product',
                            'uniqueField'   => 'uri',
                            'exclude'    => $this->get('id'),
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'visibility',
                'required'  => false,
                'filters'   => array (
                    new DefaultValue (false)
                ),
            ))
            ->add (array (
                'name'      => 'btob',
                'required'  => false,
                'filters'   => array (
                    new DefaultValue (false)
                ),
            ))
            ->add (array (
                'name'      => 'price',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'wholesale_price',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'quantity',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'special_price',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'has_special_price',
                'required'  => false,
                'filters'   => array (
                    new DefaultValue (false)
                ),
            ))
            ->add (array (
                'name'      => 'created_date',
                'required'  => false,
                'filters'   => array (
                ),
            ))
            ->add (array (
                'name'      => 'special_date_start',
                'required'  => false,
                'filters'   => array (
                ),
            ))
            ->add (array (
                'name'      => 'special_date_end',
                'required'  => false,
                'filters'   => array (
                ),
            ))
            ->add (array (
                'name'      => 'width',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'weight',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'length',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'depth',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'height',
                'filters'   => array ($zero),
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'tax_class_id',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))
            ->add (array (
                'name'      => 'primary_category_id',
                'required'  => false,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))
            ->add ($locales, 'locales')
            ->add (array (
                'name'      => 'shipping_type',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'shipping_fixed_price',
                'required'  => true,
                'filters'   => array ($zero),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'video_uri',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 256,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'video_uri_user',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 256,
                        )
                    )

                ),
            ))
            ->add (array (
                'name'      => 'html',
                'required'  => false,
                'filters'   => array (
                    new DefaultValue ('')
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 0,
                            'max' => 16000,
                        )
                    )

                ),
            ));
    }

    /**
     * @param $data
     * @param Product $entity
     */
    protected function onPresetData (&$data, $entity)
    {
        $this->applyLocales ($data, $entity);
        $this->applyMediaAttachment ($data, $entity);
        $this->applyMainImage ($data, $entity);
        $this->applyCategories ($data, $entity);
        $this->applyProperties ($data, $entity);
        $this->applyBrand ($data, $entity);
        $this->applyTierPrices ($data, $entity);
        $this->applyRelated ($data, $entity);
        $this->applyFile($data, $entity);
    }


    /**
     * @param $data
     * @param Product $entity
     */
    protected function applyBrand ($data, Product $entity)
    {
        $brand = null;

        if (!empty ($data ['brand'] ['id']))
        {
            $brand = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Product\Entity\Brand')
                ->find ($data ['brand'] ['id']);
        }

        $entity->attachBrand ($brand);
    }


    /**
     * Apply Property
     *
     * @param $data
     * @param Product $entity
     */
    protected function applyProperties ($data, Product $entity)
    {
        if (!isset ($data ['properties']))
        {
            return;
        }

        $attached = array ();
        $keys = $entity
            ->getProperties ()
            ->getKeys ();

        foreach ($data ['properties'] as $position  => $property)
        {
            if ($property ['id'])
            {
                $id = $property ['id'];

                $relation = $entity
                    ->getProperties ()
                    ->filter (
                        function (Relation $rel) use ($id)
                        {
                            return $rel->getId () == $id;
                        }
                    )->first ();

                    $attached [] = $entity
                        ->getProperties ()
                        ->indexOf ($relation);
            }
            else
            {
                $relation = new Relation ();
            }

            $propertyAssign = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Product\Entity\Property')
                ->find ($property ['property_id']);

            $valueId = $property ['value_id'];

            $valueAssigned = $propertyAssign
                ->getValues ()
                ->filter (
                    function (Property\Value $value) use ($valueId)
                    {
                        return $value->getId () == $valueId;
                    }
                )->first ();


            $relation->setProduct    ($entity);
            $relation->setProperty   ($propertyAssign);
            $relation->setValue      ($valueAssigned);
            $relation->setPosition   ($position);

            $entity->addProperty ($relation);
        }

        foreach (array_diff ($keys, $attached) as $removeIndex)
        {
            $entity->removeProperty ($entity->getProperties ()->get ($removeIndex));
        }
    }

    /**
     * @param $data
     * @param Product $entity
     */
    protected function applyCategories ($data, Product $entity)
    {
        $attach = array ();

        if (!isset ($data ['categories']))
        {
            return;
        }

        foreach ($data ['categories'] as $id => $assigned)
        {
            $assigned
                ? $attach [] = $id
                : $entity->removeCategory ($entity->getCategories ()->get ($id));
        }

        $categories = $this
            ->getEntityManager ()
            ->getRepository ('MotoStore\Product\Entity\Category')
            ->findBy (array('id' => $attach));


        $entity->attachCategories ($categories);
    }


    /**
     * Handle Locales
     *
     * @param $data
     * @param Product $entity
     */
    protected function applyLocales ($data, Product $entity)
    {
        foreach ($data['locales'] as $localeCode => $localeData)
        {
            $locale = $entity->getLocaleByLanguageCode ($localeCode);

            $this
                ->hydrator
                ->hydrate ($localeData, $locale);

            if (!$locale->getId ())
            {
                $locale->setProduct($entity);
                $entity->addLocale ($locale);
            }
        }

    }

    /**
     * Main Image
     *
     * @param $data
     * @param Product $entity
     */
    protected function applyMainImage  ($data, Product $entity)
    {
        $image = null;

        if (!empty ($data ['image'] ['id']))
        {
            $image = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->find (array ('id' => $data ['image'] ['id']));
        }

        $entity->attachMainImage ($image);
    }


    protected function applyFile  ($data, Product $entity)
    {
        $file = null;

        if (!empty ($data ['file'] ['id']))
        {
            $file = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Platform\Entity\Media')
                ->find (array ('id' => $data ['file'] ['id']));
        }

        $entity->attachFile($file);
    }

    /**
     * Handle Media Changes
     *
     * @param $data
     * @param Product $entity
     */
    protected function applyMediaAttachment ($data, Product $entity)
    {

        if (!isset ($data ['images']))
        {
            return;
        }

        $em = $this->getEntityManager ();
        $relations = $em
            ->getRepository ('MotoStore\Product\Entity\MediaRelation')
            ->findBy (array('product_id' => $entity->getId()));
        foreach ($relations as $item)
        {
            $em->remove ($item);
        }

        if ($data ['images'])
        {


            $imagesdata = $data ['images'];



                foreach ($imagesdata as $mediaRelation)
                {


                    $relation = new MediaRelation ();


                    $metiaItem =  $em
                        ->getRepository ('MotoStore\Platform\Entity\Media')
                        ->find (array ('id' => $mediaRelation ['media_id']));

                    $relation->setPosition (isset($mediaRelation['position'])?$mediaRelation['position']:0);
                    $relation->setMedia ($metiaItem);
                    $relation->setProduct ($entity);

                    $em->persist ($relation);

                }

                $em->flush();



        }
    }

    /**
     *
     * Save tier price data
     * @param $data
     * @param Product $entity
     */
    protected function applyTierPrices ($data, Product $entity)
    {
        $actualPrices = array ();
        $em = $this->getEntityManager ();

        foreach ($data ['tier_prices'] as $price)
        {
            $tierPrice = null;

            /**
             * Try to find in collection
             */
            if ($price ['id'])
            {
                $tierPrice = $entity->getTierPrices()->filter (function (TierPrice $tp) use ($price) {

                    return $tp->getId () == $price ['id'];

                })->first ();
            }


            /**
             * If price not exists create an price
             */
            if (!$tierPrice)
            {
                $tierPrice = new TierPrice ();
            }
            else
            {
                $actualPrices[] = $tierPrice->getId ();
            }

            /**
             * Update values
             */
            $tierPrice->setQuantity($price ['quantity']);
            $tierPrice->setPrice($price ['price']);
            $tierPrice->setProduct($entity);

            $entity->addTierPrice ($tierPrice);


            $tierPrice->getId ()
                ? $em->merge ($tierPrice)
                : $em->persist ($tierPrice);
        }

        /**
         * Remove not actual prices
         */
        array_map (function (TierPrice $tp) use ($actualPrices, $em){

            if (!in_array ($tp->getId (), $actualPrices))
            {
                $em->remove ($tp);

            }
        }, $entity->getTierPrices()->toArray ());

    }
    /**
     * Set related
     *
     * @param $data
     * @param Product $entity
     */
    protected function applyRelated ($data, Product $entity)
    {
        $em = $this->getEntityManager ();
        $related = $em
            ->getRepository ('MotoStore\Product\Entity\Related')
            ->findBy (array('main_product_id' => $entity->getId()));
        foreach ($related as $item)
        {
            $em->remove ($item);
        }
        $em->flush ();

        $hydrator = $this->hydrator;

        $products = array_map (
            function ($data) use ($hydrator, $entity)
            {
                /**
                 * @var Product $product
                 */
                $product = $hydrator
                    ->hydrate ($data, new Related ());
                $product
                    ->setMainProduct ($entity);

                return $product;
            },
            $data ['related']
        );

        $entity->setRelated($products);
    }
}