<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Form;


use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;

class PropertyType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array ();
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 255,
                        )
                    )

                ),
            ))
        ->add (array (
        'name'      => 'image',
        'required'  => false,
        'filters'=> array (
            array ('name' => 'StringTrim'),
            array('name' => 'StripTags'),
        )
    ));


    }

    /**
     * @param $data
     * @param Property $entity
     */
    protected function onPresetData (&$data, $entity)
    {
        $this->applyPropertyValues ($data, $entity);
    }

    /**
     * Main Image
     *
     * @param $data
     * @param Property $entity
     */
    protected function applyPropertyValues ($data, Property $entity)
    {
        $keys = $entity->getValues ()->getKeys ();

        $attach = array ();

        foreach ($data ['values'] as $value)
        {
            if ($value ['id'])
            {
                $id = $value['id'];
                /**
                 * @var Property\Value $propertyValue
                 */
                $propertyValue = $entity
                    ->getValues ()
                    ->filter (
                        function (Property\Value $value) use ($id) {

                            return $value->getId () == $id;
                        }
                    )->first ();

                if ($propertyValue)
                {
                    $propertyValue->setValue ($value['value']);
                    $index = $entity
                        ->getValues ()
                        ->indexOf ($propertyValue);
                    if ($index !== false)
                    {
                        $attach[] = $index;
                    }
                }
            }
            else
            {
                $propertyValue = new Property\Value ();
                $propertyValue->setValue ($value ['value']);
                $propertyValue->setProperty ($entity);
                $entity->addValue ($propertyValue);
            }
        }

        foreach (array_diff ($keys, $attach) as $removeIndex)
        {
            $entity->removeValue ($entity->getValues ()->get ($removeIndex));
        }
    }
}