<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Product\Link;


use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Product\Repository\CategoryRepository;

class Category extends Moto\ClickAction\AbstractClickAction
{
    protected $_defaultData = array(
        'id' => null,
        'target' => '_self',
        'nofollow' => 0,
    );

    /**
     * Get Entity Url
     * @return string
     */
    public function getUrl ()
    {
        $url        = '';
        $identifier = $this->get ('id');

        if (empty ($identifier))
        {
            return $url;
        }

        /** @var \MotoStore\Product\Entity\Category $category */
        $category = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category')
            ->find ($identifier);

        if ($category)
        {
            $url = Link::storeLink(Link::URI_SECTION_CATEGORY, $category->getUri ());

        }

        if (!empty ($this->_data['anchor']))
        {
            $url .= '#' . $this->_data['anchor'];
        }
        return $url;
    }

    /**
     * @param $url
     * @param null $query
     * @return string
     */
    public static function buildUrl($url, $query = null)
    {
        if (is_array($query)) {
            $query = http_build_query($query);
        } else {
            $query = '';
        }

        if (!empty($url)) {
            if (self::$_usingPermalinks) {
                if (self::$_usingHtmlSuffix) {
                    $url .= '.html';
                } else {
                    $url = rtrim($url, '/') . '/';
                }
            }
            else {
                $url = ltrim($url, '/');
                $url = '?url=' . $url;
            }
        }

        if (!empty($query)) {
            if (self::$_usingPermalinks) {
                $url .= '?' . $query;
            } else {
                $url .= '&' . $query;
            }
        }
        return $url;
    }

    public function isCurrent($properties, $linker)
    {
        if (!empty ($properties ['id']))
        {
            /** @var CategoryRepository $categoryRepository */
            $categoryRepository = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Category');


            $category = $categoryRepository->getCategory(Link::getEntityUri(Link::URI_SECTION_CATEGORY));
            if ($category && $category->getId () == $properties ['id'])
            {
                return true;
            }
        }
        return false;
    }
}