<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Repository;


use Doctrine\DBAL\LockMode;
use Doctrine\ORM\EntityNotFoundException;
use Doctrine\ORM\EntityRepository;
use MotoStore\Product\Entity\Category\Relation;
use MotoStore\Product\Entity\Product;
use MotoStore\Content\Content\DI\SMStatic;

/**
 * Class ProductRepository
 * @package MotoStore\Product\Repository
 */
class ProductRepository extends EntityRepository
{
    /**
     * Current store directory
     *
     * @var Product
     */
    private $product;

    /**
     * Retrieve product or load from cache
     *
     * @param $uri
     * @return Product|null|object
     */
    public function getProduct ($uri)
    {
        if (!$this->product)
        {
            $this->product = $this->_em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->findOneBy (array (
                    'uri' => $uri
                ));

            $this->normalizeExternalResource ($this->product);
        }
        if ($this->product && !$this->isCustomerBtob() && $this->product->getBtob()){

             $this->product = false;

        }


        return $this->product;
    }

    protected  function isCustomerBtob()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();
        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                return (bool)$customer->getBtob ();
            }
        }
        return false;

    }
    /**
     * Update product position in the category
     *
     * @param $id
     * @param $categoryID
     * @param $position
     * @return bool
     */
    public function updatePosition ($id, $categoryID, $position)
    {
        /** @var Relation $relation */
        $relation = $this->_em->getRepository ('MotoStore\Product\Entity\Category\Relation')
            ->findOneBy(array(
                'product_id' => $id,
                'category_id' => $categoryID
            ));

        if ($relation)
        {
            $relation->setPosition ($position);
            $this->_em->merge ($relation);
            $this->_em->flush ();
            return true;
        }
        return false;
    }

    /**
     * @param mixed $id
     * @param int $lockMode
     * @param null $lockVersion
     * @return null|object
     */
    public function find($id, $lockMode = LockMode::NONE, $lockVersion = null)
    {
        $entity =  parent::find($id, $lockMode, $lockVersion);

        $this->normalizeExternalResource ($entity);

        return $entity;
    }


    /**
     * @param Product|null $entity
     */
    private function normalizeExternalResource (Product $entity = null)
    {
        if ($entity)
        {
            try
            {
                if ($entity->getImage ())
                {
                    $entity->getImage ()->getPath ();
                }
            }
            catch (EntityNotFoundException $e)
            {
                $entity->attachMainImage (null);
            }

        }
    }

    /**
     * Retrieve product or load from cache
     *
     * @param $id
     * @return Product|null|object
     */
    public function getProductById ($id)
    {
       $result = $this->_em
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->findOneBy (array (
                    'id' => $id
                ));
        if ($result && !$this->isCustomerBtob() && $result->getBtob()){

            $result = false;

        }
        return $result;
    }

    public function getProductByBrandId ($id)
    {
       /* $result = $this->_em
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->findBy (array (
                'brand' => array('id'=>$id)
            ));
        return $result;*/

        $qb = $this->_em->createQueryBuilder ();

        $query = $qb
            ->select (array (
                'i.path',
                'p.sku',
                'p.upc',
                'l.name',
                'p.id',
            ))
            ->from ('MotoStore\Product\Entity\Product', 'p')
            ->leftJoin ('p.locales', 'l')
            ->leftJoin ('p.image', 'i')
            ->leftJoin ('p.brand', 'b')
            ->where ($qb->expr ()->eq ('b.id', $id));


        return $query->getQuery()->getArrayResult ();
    }

}