<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Service;

use Doctrine\ORM\Query;
use MotoStore\Product\Entity\Category;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Form\CategoryType;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Product\Entity\CategoryProperty\Relation as PropertyRelation;
use MotoStore\Product\Entity\CategoryBrand\Relation as BrandRelation;

class CategoryServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'category';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.category';
    }


    /**
     * Save Resource

     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new CategoryType (), new Category ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $ids = $this->fetchChild (array ($id));

        if ($ids)
        {
            return $this->removeIds ($ids);
        }
        return null;
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        $params = $this->getParams ();

        return $this
            ->collection
            ->setFilters ($params->getFilters ())
            ->setLimit ($params->getLimit ())
            ->setOffset ($params->getOffset ())
            ->setOrder ($params->getOrder ())
            ->getCollectionWithMetaData (function ($item) {

                $item ['categories'] = array ();

                return $item ;
            });
    }
    
    public function getTree ($show_btob = true)
    {
        return $this
            ->collection
            ->getEntityManager ()
            ->getRepository('MotoStore\Product\Entity\Category')
            ->getTree ($show_btob);
    }
    

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id);
    }

    /**
     * Remove categories ids
     *
     * @param $ids
     */
    private function removeIds ($ids)
    {
        $q = $this
            ->collection
            ->getEntityManager ()
            ->createQueryBuilder ();
        $q->delete ()
            ->from ('MotoStore\Product\Entity\Category', 'c')
            ->where ($q->expr ()->in ('c.id', $ids))
            ->getQuery ()
            ->execute ();
    }

    /**
     * Fetch Child ids
     *
     * @param array $ids
     * @param array $remove
     * @return array
     */
    private function fetchChild ($ids = array (), &$remove = array ())
    {
        $q = $this
            ->collection
            ->getEntityManager ()
            ->createQueryBuilder ();

        $child = $q
            ->select(array ('c.id'))
            ->from ('MotoStore\Product\Entity\Category', 'c')
            ->where ($q->expr ()->in ('c.parent_id', $ids))
            ->getQuery ()
            ->getArrayResult ();

        if ($child)
        {
            $vector = array_map (function ($element) {

                return $element ['id'];
            }, $child);
            $remove = array_merge ($remove, $vector);
            $this->fetchChild ($vector, $remove);
        }
        return array_unique (array_merge ($remove, $ids));
    }

    public function getProducts ($category_id)
    {
        return $this
            ->collection
            ->getEntityManager ()
            ->getRepository('MotoStore\Product\Entity\Category')
            ->fetchCategoryProducts ($category_id);
    }



    public function saveProperties(){
        $params = $this->_request->getParams ();

        if (isset ($params ['properties']) && !empty ($params ['cat_id']))
        {

            $category_id    = $params ['cat_id'];
            $em = $this
                ->collection
                ->getEntityManager ();

            $entity = $em->getRepository ('MotoStore\Product\Entity\Category')
                ->find ($category_id);
            $attached = array ();
            $keys = $entity
                ->getProperties ()
                ->getKeys ();
            foreach ($params ['properties'] as $property)
            {
                $relation = new PropertyRelation ();
                $propertyAssign = $this
                    ->collection
                    ->getEntityManager ()
                    ->getRepository ('MotoStore\Product\Entity\Property')
                    ->find ($property ['id']);
                $relation->setCategory  ($entity);
                $relation->setProperty  ($propertyAssign);
                $entity->addProperty ($relation);
            }
            foreach (array_diff ($keys, $attached) as $removeIndex)
            {
                $entity->removeProperty ($entity->getProperties ()->get ($removeIndex));
            }

            $em->flush();
        }
    }

    public function saveBrands(){
        $params = $this->_request->getParams ();
        if (isset($params ['brands']) && !empty ($params ['cat_id']))
        {

            $category_id    = $params ['cat_id'];
            $em = $this
                ->collection
                ->getEntityManager ();

            $entity = $em->getRepository ('MotoStore\Product\Entity\Category')
                ->find ($category_id);
            $attached = array ();
            $keys = $entity
                ->getBrands ()
                ->getKeys ();
            foreach ($params ['brands'] as $brand)
            {
                $relation = new BrandRelation();
                $brandAssign = $this
                    ->collection
                    ->getEntityManager ()
                    ->getRepository ('MotoStore\Product\Entity\Brand')
                    ->find ($brand ['id']);
                $relation->setCategory  ($entity);
                $relation->setBrand ($brandAssign);
                $entity->addBrand ($relation);
            }
            foreach (array_diff ($keys, $attached) as $removeIndex)
            {
                $entity->removeBrand ($entity->getBrands ()->get ($removeIndex));
            }

            $em->flush();
        }
    }

    function assignPropertyToCategory ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']) && !empty ($params ['cat_id']))
        {
            $property_id     = $params ['id'];

            $em = $this
                ->collection
                ->getEntityManager ();

            /** @var Product $entity */
            $entity = $em->getRepository ('MotoStore\Product\Entity\Property')
                ->find ($property_id);

            $categories = $this
                ->collection
                ->getEntityManager ()
                ->getRepository ('MotoStore\Product\Entity\Category')
                ->findBy (array('id' => $params ['cat_id']));
            $categories->attachProperties ($entity);
            $em->flush();
        }

    }


    public function removePropertyFromCategory ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']) && !empty ($params ['cat_id']))
        {
            $product_id     = $params ['id'];

            $em = $this
                ->collection
                ->getEntityManager ();

            /** @var Product $entity */
            $entity = $em->getRepository ('MotoStore\Product\Entity\Product')
                ->find ($product_id);

            $entity->removeCategory($entity->getCategories ()->get ($params ['cat_id']));
            $em->flush();
        }

    }


}