<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Service;

use Doctrine\ORM\Query;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Form\PropertyType;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\StoreServiceAbstract;

class PropertyServiceClass extends StoreServiceAbstract implements  ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'property';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.property';
    }


    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new PropertyType (), new Property ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        return $this
            ->handleCollectionRequest ();
    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id);
    }


}