<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Product\Service;

use Doctrine\ORM\Query;
use MotoStore\Product\Entity\Variant;
use MotoStore\Product\Form\VariantType;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\ServiceSearchableInterface;
use MotoStore\Service\StoreServiceAbstract;


class VariantServiceClass extends StoreServiceAbstract
    implements ServiceReadableInterface, ServiceEditableInterface, ServiceSearchableInterface
{
    protected $_resourcePrivilegesMap = array (
        'getCollection' => 'get',
        'search' => 'get',
        'getItem' => 'get',
    );

    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'variant';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName()
    {
        return 'store.collection.variant';
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest(new VariantType(), new Variant ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        return $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        return $this
            ->handleCollectionRequest ();
    }


    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id);
    }

    /**
     * Retrieve Items Collection by Text
     *
     * @param $searchText
     * @param $limit
     * @param $offset
     * @return mixed
     */
    public function search ($searchText, $limit, $offset)
    {
        
    }
}