<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Service;


use Moto\Json\Server;
use MotoStore\Platform\Module\ModuleAbstract;
use Zend\EventManager\Event;

class Module extends ModuleAbstract
{
    private $permissionsDemo =  array (
        'roles' => array(
            'demo' => array(
                'parents' => array('guest'),
            )
        ),
        'access' => array(
            array(
                'role' => 'demo',
                'resource' => array(
                    'content',
                    'extra',
                    'roles',
                    'fileManager',
                    'fonts',
                    'languages',
                    'mediaLibrary',
                    'menus',
                    'pages',
                    'profile',
                    'roles',
                    'settings',
                    'styles',
                    'theme',
                    'themes',
                    'updates',
                    'users',
                    'presets',


                    'store_customer',
                    'store_dashboard',
                    'store_country',
                    'store_state',
                    'store_mail_template',
                    'store_order',
                    'store_brand',
                    'store_category',
                    'store_product',
                    'store_property',
                    'store_payment',
                    'store_currency',
                    'store_discount',
                    'store_settings',
                    'store_tax',
                    'store_taxzone',
                ),
                'privileges' => array('get'),
                'allow' => true
            ),
            array('role' => 'guest', 'resource' => array('auth'), 'allow' => false),
            array('role' => 'guest', 'resource' => array('auth'), 'privileges' => array('login', 'isAuthenticated', 'logout'), 'allow' => true),
            array('role' => 'guest', 'resource' => array('store_country', 'store_product', 'store_customer'), 'privileges' => array('get'), 'allow' => true),
        )
    );

    /**
     * Return module config
     *
     * @return array
     */
    public function getModuleConfig ()
    {
        return include __DIR__ . DIRECTORY_SEPARATOR .  'config' . DIRECTORY_SEPARATOR . 'module.config.php';
    }

    /**
     * Module Name
     * @return string
     */
    public function getName ()
    {
        return 'Service';
    }


    public function bootstrap ()
    {
        $this->addAclRules ();
        $serviceLocator = $this->getServiceLocator ();

        $this->getEventManager ()->attach ('store.event.modules.loaded', function (Event $e) use ($serviceLocator) {

            $config = $serviceLocator->get ('store.config');

            /** @var Server $service */
            $service = $serviceLocator->get ('store.motocms.rpc');

            foreach ($config ['Services'] as $namespace => $serviceClass)
            {
                $service
                    ->assignClass (
                        function () use ($serviceClass, $serviceLocator)
                        {
                            return new $serviceClass ($serviceLocator);
                        }
                    , $namespace);
            }
        });
    }


    /**
     * Service Permissions
     */
    protected function addAclRules ()
    {
        $permissions = array ();

        $permissions['resources'] = array (
            'store_customer' => array(),
            'store_dashboard' => array(),
            'store_country' => array(),
            'store_state' => array(),
            'store_mail_template' => array(),
            'store_order' => array(),
            'store_brand' => array(),
            'store_category' => array(),
            'store_product' => array(),
            'store_variant' => array(),
            'store_property' => array(),
            'store_currency' => array(),
            'store_discount' => array(),
            'store_settings' => array(),
            'store_payment' => array(),
            'store_tax' => array(),
            'store_taxzone' => array(),
        );

        $permissions['access'] = array(
            array('role' => 'guest', 'resource' => array('store_country', 'store_product', 'store_customer'), 'allow' => false),
            array('role' => 'guest', 'resource' => array('store_country', 'store_product', 'store_customer'), 'privileges' => array('get'), 'allow' => true),

        );

        if (\Moto\Config::get('isDemoMode'))

        {
            $permissions = array_merge ($permissions, $this->permissionsDemo);
        }

        \Moto\Application\Acl\Adapter::addRules($permissions);
    }
}