<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class TaxZone implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select(array ('z', 'r', 'rt', 'c', 's'))
            ->from ('MotoStore\Settings\Entity\Tax\Zone', 'z')
            ->leftJoin ('z.regions', 'r')
            ->leftJoin ('r.country', 'c')
            ->leftJoin ('c.states', 's')
            ->leftJoin ('z.rates', 'rt');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'name' => 'c.name',
        ));

        return $collection;
    }
}