<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Settings\Entity;

use Doctrine\ORM\Mapping as ORM;


/**
 * @ORM\Entity
 * @ORM\Table (name="store_currency",options={"engine":"InnoDB"})
 * @ORM\Entity(repositoryClass="MotoStore\Settings\Repository\CurrencyRepository")
 */
class Currency
{
    const CURRENCY_LOCATION_LEFT    = 'left';
    const CURRENCY_LOCATION_RIGHT   = 'right';
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string", length=3) */
    protected $code;

    /** @ORM\Column(type="string", length=45) */
    protected $name;

    /** @ORM\Column(type="string", length=4)  */
    protected $token;

    /** @ORM\Column(type="integer") */
    protected $decimal_places;

    /** @ORM\Column(type="string", length=1) */
    protected $decimal_point;

    /** @ORM\Column(type="string", length=1) */
    protected $thousands_separator;

    /** @ORM\Column(type="string", length=10) */
    protected $location;

    /** @ORM\Column(type="decimal", precision=10, scale=2) */
    protected $exchange_rate = 1;

    /** @ORM\Column(type="boolean", options={"default"=1}) */
    protected $active;

    /** @ORM\Column(type="boolean", options={"default"=0}) */
    protected $spacer;

    /**
     * Get allowed locations
     * @return array
     */
    public static function getLocations ()
    {
        return array (
            self::CURRENCY_LOCATION_LEFT    => 'Left',
            self::CURRENCY_LOCATION_RIGHT   => 'Right',
        );
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param mixed $code
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @param mixed $token
     * @return $this
     */
    public function setToken($token)
    {
        $this->token = $token;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDecimalPlaces()
    {
        return $this->decimal_places;
    }

    /**
     * @param mixed $decimal_places
     * @return $this
     */
    public function setDecimalPlaces($decimal_places)
    {
        $this->decimal_places = $decimal_places;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getDecimalPoint()
    {
        return $this->decimal_point;
    }

    /**
     * @param mixed $decimal_point
     * @return $this
     */
    public function setDecimalPoint($decimal_point)
    {
        $this->decimal_point = $decimal_point;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getThousandsSeparator()
    {
        return $this->thousands_separator;
    }

    /**
     * @param mixed $thousands_separator
     * @return $this
     */
    public function setThousandsSeparator($thousands_separator)
    {
        $this->thousands_separator = $thousands_separator;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @return mixed
     */
    public function getExchangeRate()
    {
        return $this->exchange_rate;
    }

    /**
     * @param mixed $exchange_rate
     * @return $this
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->exchange_rate = $exchange_rate;

        return $this;
    }

    /**
     * @param mixed $location
     * @return $this
     */
    public function setLocation($location)
    {
        $this->location = $location;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param mixed $active
     * @return $this
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSpacer()
    {
        return $this->spacer;
    }

    /**
     * @param mixed $spacer
     * @return $this
     */
    public function setSpacer($spacer)
    {
        $this->spacer = $spacer;
        return $this;
    }
}