<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Settings\Entity\Tax;

use Doctrine\ORM\Mapping as ORM;

/** @ORM\Entity @ORM\Table(name="store_tax_class",options={"engine":"InnoDB"}) */
class TaxClass
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /** @ORM\Column(type="string", length=45) */
    protected $name;

    /** @ORM\Column(type="boolean") */
    protected $enabled;

    /**
     * @ORM\OneToMany(targetEntity="MotoStore\Settings\Entity\Tax\Rate", mappedBy="class", cascade={"persist", "remove", "merge"})
     * @var \Doctrine\Common\Collections\ArrayCollection
     */
    protected $rates;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param mixed $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return mixed
     */
    public function getRates()
    {
        return $this->rates;
    }

    /**
     * @param mixed $rates
     */
    public function setRates($rates)
    {
        $this->rates = $rates;
    }
}