<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Form;


use MotoStore\Platform\Doctrine\Strategy\DateTimeStrategy;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Settings\Entity\Discount;

class DiscountType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
            'date_start'    => new DateTimeStrategy (),
            'date_end'      => new DateTimeStrategy (),
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'value',
                'required'  => true,
                'filters'=> array (
                    new DefaultValue (0)
                ),
                'validators'=> array (
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Numeric',
                        'options' => array(
                            'min' => 0,
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'code',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 4,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add(array (
                'name'      => 'date_start',
                'required'  => true,
                'validators'=> array (),
            ))
            ->add(array (
                'name'      => 'date_end',
                'required'  => true,
                'validators'=> array (),
            ))
            ->add (array (
                'name'      => 'type',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )

                ),
            ))
            ->add (array (
                'name'      => 'quantity',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'Digits',
                    )
                ),
            ))
            ->add (array (
                'name'      => 'active',
                'required'  => false,
                'filters'=> array (
                    new DefaultValue (0)
                ),
            ))
            ->add (array (
                'name'      => 'apply_to_shipping',
                'required'  => false,
                'filters'=> array (
                    new DefaultValue (0)
                ),
            ));
    }

    /**
     * @param $data
     * @param Discount $entity
     */
    protected function onDataValid(&$data, $entity)
    {
        if (!$entity->getId ())
        {
            $entity->setUsage (0);
        }
    }


}