<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Form;


use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Settings\Entity\Tax\Rate;
use MotoStore\Settings\Entity\Tax\Region;
use MotoStore\Settings\Entity\Tax\Zone;

class ZoneType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $this
            ->add (array (
                'name'      => 'name',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 1,
                            'max' => 45,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'enabled',
                'required'  => false,
                'filters'=> array (
                    new DefaultValue (0)
                ),
            ));
    }

    /**
     * @param $data
     * @param Zone $entity
     */
    protected function onPresetData(&$data, $entity)
    {
        $this->applyRate ($data, $entity);
        $this->applyRegion ($data, $entity);
        $this->applyStateRegions ($data, $entity);

    }

    /**
     * @param $data
     * @param Zone $entity
     */
    protected function applyRegion ($data, Zone $entity)
    {
        foreach ($data ['countries'] as $country_id => $state)
        {
            if ($entity->getId ())
            {
                $region = $this
                    ->getEntityManager ()
                    ->getRepository ('MotoStore\Settings\Entity\Tax\Region')
                    ->findOneBy (array (
                        'country_id' => $country_id,
                        'zone_id'   => $entity->getId ()
                    ));

                if ($region && !$state)
                {
                    $this
                        ->getEntityManager ()
                        ->remove($region);

                    $this
                        ->getEntityManager ()
                        ->flush ();
                }
                if (!$region && $state)
                {
                    $this->countryRegion($country_id, $entity);

                }
            }
            else
            {
                $this->countryRegion($country_id, $entity);
            }
        }



    }

    /**
     * @param $data
     * @param $entity
     */
    protected function applyStateRegions ($data, $entity)
    {

        if (empty ($data ['states']))
        {
            return;
        }

        foreach ($data ['states'] as $state_id => $state)
        {
            if ($entity->getId ())
            {
                $region = $this
                    ->getEntityManager ()
                    ->getRepository ('MotoStore\Settings\Entity\Tax\Region')
                    ->findOneBy (array (
                        'state_id' => $state_id,
                        'zone_id'   => $entity->getId ()
                    ));

                if ($region && !$state)
                {
                    $this
                        ->getEntityManager ()
                        ->remove($region);

                    $this
                        ->getEntityManager ()
                        ->flush ();
                }

                if (!$region && $state)
                {
                    $this->stateRegion($state_id, $entity);

                }
            }
            else
            {
                $this->stateRegion($state_id, $entity);
            }
        }

    }

    /**
     * @param $state_id
     * @param $entity
     */
    private function stateRegion ($state_id, $entity)
    {
        $region = new Region ();

        $state = $this
            ->getEntityManager ()
            ->getRepository ('MotoStore\Localization\Entity\State')
            ->find ($state_id);

        $region->setZone ($entity);
        $region->setState ($state);
        $entity->addRegion ($region);
    }

    /**
     * @param $country_id
     * @param $entity
     */
    private function countryRegion ($country_id, $entity)
    {
        $region = new Region ();

        $country = $this
            ->getEntityManager ()
            ->getRepository ('MotoStore\Localization\Entity\Country')
            ->find ($country_id);

        $region->setCountry ($country);
        $region->setZone ($entity);
        $entity->addRegion ($region);

    }


    /**
     * Apply Tax Class Rates
     *
     * @param $data
     * @param Zone $entity
     */
    protected function applyRate ($data, Zone $entity)
    {
        foreach ($data ['rates'] as $rate)
        {
            if (isset($rate ['id']))
            {
                /**
                 * @var Rate $rateEntity
                 */
                $rateEntity = $this
                    ->getEntityManager ()
                    ->getRepository ('MotoStore\Settings\Entity\Tax\Rate')
                    ->find ($rate ['id']);
            }
            else
            {
                $rateEntity = new Rate ();
            }

            $class = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Settings\Entity\Tax\TaxClass')
                ->find ($rate ['class_id']);

            $rateEntity->setRate (isset($rate ['rate']) ? $rate ['rate'] : 0);
            $rateEntity->setZone ($entity);
            $rateEntity->setClass ($class);
            $entity->addRate ($rateEntity);
        }
    }


}