<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\Query;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Discount;
use MotoStore\Settings\Form\DiscountType;
use MotoStore\Content\Content\DI\SMStatic;

class DiscountServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'discount';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
        return 'store.collection.discount';
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        return $this
            ->handleUpdateRequest (new DiscountType (), new Discount ());
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {


        $collection = SMStatic::getInstance ()->get ('store.collection.discount');
        $params = $this->getParams ();
        $filters = $params->getFilters ();
        $active_dates = array();
        foreach ($filters  as $key => $filter){
            if ($filter['field']  == 'active_dates'){
                $active_dates = $filters[$key];
                unset($filters[$key]);
            }
        }
        $collection->setFilters($filters);

        if (isset($active_dates['value']) && isset($active_dates['value'][0]) && isset($active_dates['value'][1])){

             $datefrom = strtotime($active_dates['value'][0]);
            $dateto = strtotime($active_dates['value'][1]);

             $datefrom = date("Y-m-d",$datefrom);
            $dateto = date("Y-m-d",$dateto);

            $collection
                ->getQuery ()
                ->andWhere(
                    '(d.date_start <= \''.$datefrom.'\' AND d.date_end >= \''.$dateto.'\') 
                    OR
                    (d.date_start <= \''.$datefrom.'\' AND d.date_end >= \''.$datefrom.'\')
                    OR
                    (d.date_start <= \''.$dateto.'\' AND d.date_end >= \''.$dateto.'\')
                    OR
                    (d.date_start >= \''.$datefrom.'\' AND d.date_end <= \''.$dateto.'\')'
                );

        }

        return $collection->setLimit ($params->getLimit ())
            ->setOffset ($params->getOffset ())
            ->setOrder ($params->getOrder ())
            ->getCollectionWithMetaData (function ($discount)
            {
                /** @var \DateTime $dateStart  */
                $dateStart = $discount ['date_start'];

                if ($dateStart) {
                    $discount ['date_start'] = $dateStart->getTimestamp() * 1000;
                }

                /** @var \DateTime $dateEnd */
                $dateEnd = $discount ['date_end'];

                if ($dateEnd) {
                    $discount ['date_end'] = $dateEnd->getTimestamp() * 1000;
                }

                return $discount;
            });

    }

    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        return $this
            ->collection
            ->setHydrationMode (Query::HYDRATE_ARRAY)
            ->getOne ($id, function (&$discount)
            {
                /** @var \DateTime $dateStart  */
                $dateStart = $discount ['date_start'];

                if ($dateStart) {
                    $discount ['date_start'] = $dateStart->getTimestamp() * 1000;
                }

                /** @var \DateTime $dateEnd */
                $dateEnd = $discount ['date_end'];

                if ($dateEnd) {
                    $discount ['date_end'] = $dateEnd->getTimestamp() * 1000;
                }

                return $discount;
            });
    }

    public function setActive ()
    {
        $params = $this->_request->getParams ();

        if (!empty ($params ['id']))
        {

            $curr_id     = $params ['id'];
            $active = false;
            if ($params ['active'] == 'true'){
                $active = true;
            }

            $em = $this
                ->collection
                ->getEntityManager ();
            /** @var Currency $entity */
            $entity = $em->getRepository ('MotoStore\Settings\Entity\Discount')
                ->find ($curr_id);
            $entity
                ->setActive($active);

            $em->flush();

        }

    }

}