<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Query;
use MotoStore\Platform\Application;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Repository\OptionRepository;
use VisualAppeal\AutoUpdate;
use Zend\ServiceManager\ServiceLocatorInterface;

class ExtensionsServiceClass extends StoreServiceAbstract
{
    /**
     * @var EntityManager
     */
    protected $entityManager;

    protected $storeConfig;

    protected $_resourcePrivilegesMap = array (
        'getCollection' => 'get',
    );

    public function __construct (ServiceLocatorInterface $serviceLocator)
    {
        $this->applyResourcePrefix ();

        $this
            ->entityManager = $serviceLocator->get ('MotoStore\EntityManager');
        $this
            ->storeConfig = $serviceLocator->get ('store.config');
    }

    protected function getPrefix ()
    {
        return 'settings';
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        $extensionsdir = MOTOSTORE_ROOT_DIR.'/extensions/';
        $plugindirs = scandir($extensionsdir);
        $plugins = [];
        foreach ($plugindirs as $plugindir){
            if ($plugindir == '.' || $plugindir == '..' || $plugindir == 'index.html' ){
                continue;
            }
            if(is_dir($extensionsdir.$plugindir) && file_get_contents($extensionsdir.$plugindir. '/extension.json')){
                $plugins []= json_decode(file_get_contents($extensionsdir.$plugindir. '/extension.json'), true);
            }
        }
        $activeplugins = $this->getActivePlugins ();
        foreach ($plugins as $key=>$plugin){
            $plugins[$key]['is_active'] = false;
            if(in_array($plugin['name'],$activeplugins)){
                $plugins[$key]['is_active'] = true;
            }
        }
        return array( 'collection' => $plugins);

    }


    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {

    }

    public function getActivePlugins ()
    {
        $moduleName = 'storesettings_extentions';
        $id ='extentions_active';
        if ($moduleName) {
            return json_decode($this->getRepository()->getOption($moduleName, $id),true);
        }
        return false;
    }
    public function deactivatePlugin($name)
    {
        $moduleName = 'storesettings_extentions';
        $option_key = 'extentions_active';

        $activeplugins = $this->getActivePlugins();
        if ($activeplugins && is_array($activeplugins) && in_array($name, $activeplugins)) {
            if (($key = array_search($name, $activeplugins)) !== false) {
                unset($activeplugins[$key]);
            }
            $option = $this
                ->entityManager
                ->getRepository('MotoStore\Settings\Entity\Option')
                ->findOneBy(array(
                    'module_name' => $moduleName,
                    'option_key' => $option_key
                ));


            if (!$option) {
                $option = new Option ($moduleName, $option_key, json_encode(array()));
                $this
                    ->entityManager->persist($option);
            } else {
                $option->setOptionValue(json_encode($activeplugins));
                $this
                    ->entityManager->merge($option);

            }

            $this
                ->entityManager
                ->flush();


        }
    }


    public function activatePlugin($name)
    {
        $moduleName = 'storesettings_extentions';
        $option_key = 'extentions_active';

        $activeplugins = $this->getActivePlugins();
        if(!$activeplugins){
            $activeplugins = [];
        }

        if (is_array($activeplugins)) {
            if (($key = array_search($name, $activeplugins)) == false) {
                $activeplugins[]=$name;
            }
            $option = $this
                ->entityManager
                ->getRepository('MotoStore\Settings\Entity\Option')
                ->findOneBy(array(
                    'module_name' => $moduleName,
                    'option_key' => $option_key
                ));
            if (!$option) {
                $option = new Option ($moduleName, $option_key, json_encode($activeplugins));
                $this
                    ->entityManager->persist($option);
            } else {
                $option->setOptionValue(json_encode($activeplugins));
                $this
                    ->entityManager->merge($option);

            }
            $this
                ->entityManager
                ->flush();
        }
    }

    /**
     * @return OptionRepository
     */
    private function getRepository ()
    {
        return $this
            ->entityManager
            ->getRepository ('MotoStore\Settings\Entity\Option');
    }
}