<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Settings\Service;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Query;
use MotoStore\Payment\Gateway\PaymentModule;
use MotoStore\Payment\Gateway\Provider;
use MotoStore\Service\ServiceEditableInterface;
use MotoStore\Service\ServiceReadableInterface;
use MotoStore\Service\StoreServiceAbstract;
use MotoStore\Settings\Entity\Option;
use Zend\ServiceManager\ServiceLocatorInterface;
use Moto;

class PaymentServiceClass extends StoreServiceAbstract implements ServiceReadableInterface, ServiceEditableInterface
{
    /**
     * @var Provider
     */
    protected $paymentProvider;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @param ServiceLocatorInterface $serviceLocator
     */
    public function __construct(ServiceLocatorInterface $serviceLocator)
    {
        $this->applyResourcePrefix ();
        $this->paymentProvider = $serviceLocator->get ('store.payment.provider');
        $this->entityManager   = $serviceLocator->get ('MotoStore\EntityManager');
    }

    /**
     * Prefix of Resource
     *
     * @return mixed
     */
    protected function getPrefix ()
    {
        return 'payment';
    }

    /**
     * Collection Name
     *
     * @return string
     */
    protected function getCollectionName ()
    {
    }

    /**
     * Save Resource
     *
     * @return mixed
     */
    public function save ()
    {
        $name = $this
            ->getParams ()
            ->get('name');

        $variables = $this
            ->getParams ()
            ->get('variables', array ());

        foreach ($variables as $var)
        {
            /**
             * @var Option $option
             */
            $option = $this
                ->entityManager
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->findOneBy (array (
                    'module_name' => $name,
                    'option_key' => $var ['key']
                ));

            if (!$option)
            {
                $option = new Option ($name, $var ['key'], $var ['model']);
                $this
                    ->entityManager->persist ($option);
            }
            else
            {
                $option->setOptionValue ($var ['model']);
                $this
                    ->entityManager->merge ($option);

            }
        }
        $this->entityManager->flush ();

        return $this
            ->getParams ()
            ->get();
    }

    /**
     * Remove Resource
     *
     * @param $id
     * @return mixed
     */
    public function delete ($id)
    {
        $this
            ->handleDeleteRequest ($id);
    }

    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getCollection ()
    {
        return array_map (
            array ($this, 'preparePaymentModel'),
            array_values($this->paymentProvider->getPaymentMethods ())
        );
    }
    /**
     * Retrieve Collection By Params
     *
     * @return mixed
     */
    public function getEnabledCollection ()
    {
        $allpayments = array_map (
            array ($this, 'preparePaymentModel'),
            array_values($this->paymentProvider->getPaymentMethods ())
        );
        $enabledpayments = [];
        foreach ($allpayments as $payment){
            if($payment['enabled']){
                $enabledpayments[]=$payment;
            }
        }
        return $enabledpayments;
    }


    /**
     * @param int $id
     * @return mixed
     */
    public function getItem ($id)
    {
        $payment = $this
            ->paymentProvider
            ->getPaymentMethod ($id);

        return $this->preparePaymentModel ($payment);
    }

    /**
     * @param PaymentModule $payment
     * @return array
     */
    private function preparePaymentModel (PaymentModule $payment)
    {
        $variables = $payment->getVariables ();

        foreach ($variables as $key => &$var)
        {
            $var ['model'] = $payment->getOption ($key) ?  $payment->getOption ($key) :  $var['default'];
        }

        if ($payment->getOption('display_name'))
        {
            $display_name = $payment->getOption('display_name');
        }
        else
        {
            $v = $payment->getVariable ('display_name');
            $display_name = $v ['default'];
        }

        $image = '';

        if ($payment->getImage ())
        {
            $image = \Moto\System::getAbsoluteUrl ('@plugins')
                . '/'
                . 'moto-store-plugin/src/modules/Payment/src/Payment/'
                . $payment->getName ()
                .  '/image/'
                . $payment->getImage ();
            $image= Moto\Hook::trigger('MOTOSTORE_HOOK_PAYMENT_IMAGE', $image, $payment->getName());

        }

        return array(
            'name'          => $payment->getName (),
            'display_name'  => $display_name,
            'description'   => $payment->getDescription (),
            'help'          => $payment->getHelpText (),
            'image'         => $image,
            'variables'     => array_values($variables),
            'enabled'       => $payment->isEnabled (),
        );
    }
}