<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update;

use MotoStore\Platform\Module\ModuleAbstract;
use MotoStore\Update\Migration\Migration;
use MotoStore\Update\Version;
use Zend\EventManager\Event;

class Module extends ModuleAbstract
{
    /**
     * Return module config
     *
     * @return array
     */
    public function getModuleConfig ()
    {
        return include __DIR__ . DIRECTORY_SEPARATOR .  'config' . DIRECTORY_SEPARATOR . 'module.config.php';
    }

    /**
     * Module Name
     * @return string
     */
    public function getName ()
    {
        return 'Update';
    }

    public function bootstrap ()
    {
        $serviceLocator = $this->getServiceLocator ();

        $this->getEventManager ()->attach ('store.event.modules.loaded', function (Event $e) use ($serviceLocator) {

            /** @var Migration $migration */
            $migration = $serviceLocator->get ('MotoStore\Migration');
            $migration->migrate ();
        });
    }
}