<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Update\Core;


use Desarrolla2\Cache\Adapter\File;
use Monolog\Handler\StreamHandler;
use VisualAppeal\AutoUpdate;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class UpdateServiceFactory implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        $config = $serviceLocator->get ('store.config');

        $updater = new AutoUpdate ($config ['store.up.config'] ['temp'], MOTOSTORE_ROOT_DIR, $config ['store.up.config'] ['timeOut']);

        $updater
            ->setCurrentVersion ('1.0.0');
        $updater
            ->addLogHandler (new StreamHandler ($config ['store.up.config'] ['log']));
        $updater
            ->setUpdateUrl ($config ['store.up.config'] ['host']);

        $updater
            ->setCache (new File ($config ['store.up.config'] ['cache']));

        return $updater;
    }
}