<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Update\Migration;


use Doctrine\ORM\EntityManager;
use MotoStore\Platform\Application;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class MigrationFactory implements FactoryInterface
{
    public function createService(ServiceLocatorInterface $serviceLocator)
    {
        /** @var EntityManager $em */
        $em = $serviceLocator->get ('MotoStore\EntityManager');
        $optionRepository = $em->getRepository ('MotoStore\Settings\Entity\Option');
        $platformVersion = Application::CURRENT_VERSION;
        $config = $serviceLocator->get ('store.config');

        return new Migration ($em, $optionRepository, $platformVersion, $config);
    }
}